/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.file.model.skin;

import java.util.UUID;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shared.storage.model.skin.PlayerSkinData;

public class PlayerSkinFile {
    private static final int CURRENT_DATA_VERSION = 1;
    private UUID uniqueId;
    private String lastKnownName;
    private String value;
    private String signature;
    private long timestamp;
    private int dataVersion;

    public static PlayerSkinFile fromPlayerSkinData(PlayerSkinData playerSkinData) {
        PlayerSkinFile playerSkinFile = new PlayerSkinFile();
        playerSkinFile.uniqueId = playerSkinData.getUniqueId();
        playerSkinFile.lastKnownName = playerSkinData.getLastKnownName();
        playerSkinFile.value = playerSkinData.getProperty().getValue();
        playerSkinFile.signature = playerSkinData.getProperty().getSignature();
        playerSkinFile.timestamp = playerSkinData.getTimestamp();
        playerSkinFile.dataVersion = 1;
        return playerSkinFile;
    }

    public PlayerSkinData toPlayerSkinData() {
        return PlayerSkinData.of(this.uniqueId, this.lastKnownName, SkinProperty.of(this.value, this.signature), this.timestamp);
    }

    @Generated
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public String getLastKnownName() {
        return this.lastKnownName;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public int getDataVersion() {
        return this.dataVersion;
    }

    @Generated
    public PlayerSkinFile() {
    }
}

