/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.file.model.skin;

import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;
import net.skinsrestorer.shared.subjects.messages.ComponentString;

public class CustomSkinFile {
    private static final int CURRENT_DATA_VERSION = 1;
    private String skinName;
    @Nullable
    private ComponentString displayName;
    private String value;
    private String signature;
    private int dataVersion;

    public static CustomSkinFile fromCustomSkinData(CustomSkinData customSkinData) {
        CustomSkinFile customSkinFile = new CustomSkinFile();
        customSkinFile.skinName = customSkinData.getSkinName();
        customSkinFile.displayName = customSkinData.getDisplayName();
        customSkinFile.value = customSkinData.getProperty().getValue();
        customSkinFile.signature = customSkinData.getProperty().getSignature();
        customSkinFile.dataVersion = 1;
        return customSkinFile;
    }

    public CustomSkinData toCustomSkinData() {
        return CustomSkinData.of(this.skinName, this.displayName, SkinProperty.of(this.value, this.signature));
    }

    @Generated
    public String getSkinName() {
        return this.skinName;
    }

    @Nullable
    @Generated
    public ComponentString getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public int getDataVersion() {
        return this.dataVersion;
    }

    @Generated
    public CustomSkinFile() {
    }
}

