/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.file.model.cooldown;

import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;

public class CooldownFile {
    private static final int CURRENT_DATA_VERSION = 1;
    private UUID uniqueId;
    private String groupName;
    private long creationTime;
    private long duration;
    private int dataVersion;

    public static CooldownFile fromCooldownData(StorageAdapter.StorageCooldown cooldownData) {
        CooldownFile cooldownFile = new CooldownFile();
        cooldownFile.uniqueId = cooldownData.owner();
        cooldownFile.groupName = cooldownData.groupName();
        cooldownFile.creationTime = cooldownData.creationTime().getEpochSecond();
        cooldownFile.duration = cooldownData.duration().getSeconds();
        cooldownFile.dataVersion = 1;
        return cooldownFile;
    }

    public StorageAdapter.StorageCooldown toCooldownData() {
        return new StorageAdapter.StorageCooldown(this.uniqueId, this.groupName, Instant.ofEpochSecond(this.creationTime), Duration.ofSeconds(this.duration));
    }

    @Generated
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public long getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public int getDataVersion() {
        return this.dataVersion;
    }

    @Generated
    public CooldownFile() {
    }
}

