/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.gson.JsonElement;
import net.skinsrestorer.shadow.gson.JsonObject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional;

public class HardcodedSkins {
    private static final Map<String, SkinProperty> SKINS = new HashMap<String, SkinProperty>();
    public static final InputDataResult STEVE;
    public static final InputDataResult ALEX;

    public static Optional<InputDataResult> getHardcodedSkin(String input) {
        String lowerCaseName = input.toLowerCase(Locale.ROOT);
        return Optional.ofNullable(SKINS.get(lowerCaseName)).map(property -> InputDataResult.of(SkinIdentifier.ofCustom(lowerCaseName), property));
    }

    static {
        Gson gson = new Gson();
        try (InputStream in = Objects.requireNonNull(HardcodedSkins.class.getClassLoader().getResourceAsStream("hardcoded_skins.json"));
             InputStreamReader reader = new InputStreamReader(in);){
            JsonObject map = gson.fromJson((Reader)reader, JsonObject.class);
            for (Map.Entry<String, JsonElement> entry : map.entrySet()) {
                String name = entry.getKey().toLowerCase(Locale.ROOT);
                JsonObject property = entry.getValue().getAsJsonObject();
                String value = property.get("value").getAsString();
                String signature = property.get("signature").getAsString();
                SKINS.put(name, SkinProperty.of(value, signature));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        STEVE = J_U_Optional.orElseThrow(HardcodedSkins.getHardcodedSkin("steve"));
        ALEX = J_U_Optional.orElseThrow(HardcodedSkins.getHardcodedSkin("alex"));
    }
}

