/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.listeners;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shared.api.SharedSkinApplier;
import net.skinsrestorer.shared.codec.SRInputReader;
import net.skinsrestorer.shared.codec.SRProxyPluginMessage;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.shared.gui.SRInventory;
import net.skinsrestorer.shared.listeners.event.SRServerMessageEvent;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.utils.RunOnce;
import net.skinsrestorer.shared.utils.SRHelpers;

public final class SRServerMessageAdapter {
    private static final RunOnce UPDATE_V2_PROXY_WARNING = new RunOnce();
    private final SRLogger logger;
    private final SRServerAdapter serverAdapter;
    private final SharedSkinApplier<Object> skinApplier;

    public void handlePluginMessage(SRServerMessageEvent event) {
        if (!event.getChannel().equals("sr:messagechannel")) {
            return;
        }
        this.serverAdapter.runAsync(() -> {
            SRServerPluginMessage message = SRServerPluginMessage.CODEC.read(new SRInputReader(event.getData()));
            SRServerPluginMessage.ChannelPayload<?> channelPayload = message.channelPayload();
            SRHelpers.mustSupply(() -> {
                Runnable runnable;
                SRServerPluginMessage.ChannelPayload channelPayload2 = channelPayload;
                Objects.requireNonNull(channelPayload2);
                SRServerPluginMessage.ChannelPayload selector3$temp = channelPayload2;
                int index$4 = 0;
                switch (SRServerMessageAdapter.jvmdowngrader$switch$lambda$handlePluginMessage$7$0(selector3$temp, index$4)) {
                    default: {
                        throw new J_L_MatchException(null, null);
                    }
                    case 0: {
                        SRInventory srInventory;
                        SRServerPluginMessage.GUIPageChannelPayload $b$0 = (SRServerPluginMessage.GUIPageChannelPayload)selector3$temp;
                        try {
                            SRInventory patt5$temp;
                            srInventory = patt5$temp = $b$0.srInventory();
                        }
                        catch (Throwable throwable) {
                            throw new J_L_MatchException(throwable.toString(), throwable);
                        }
                        runnable = () -> this.serverAdapter.openGUI(event.getPlayer(), srInventory);
                        return runnable;
                    }
                    case 1: {
                        SkinProperty skinProperty;
                        SRServerPluginMessage.SkinUpdateV2ChannelPayload $b$1 = (SRServerPluginMessage.SkinUpdateV2ChannelPayload)selector3$temp;
                        {
                            SkinProperty patt6$temp;
                            skinProperty = patt6$temp = $b$1.skinProperty();
                        }
                        runnable = () -> {
                            UPDATE_V2_PROXY_WARNING.run(() -> this.logger.warning(J_L_String.formatted("The proxy is running an outdated version of SkinsRestorer. Please update the proxy to the latest version. %s", "https://modrinth.com/plugin/skinsrestorer")));
                            this.skinApplier.applySkin(event.getPlayer().getAs(Object.class), skinProperty);
                        };
                        return runnable;
                    }
                    case 2: {
                        Optional<SRServerPluginMessage.SkinUpdateV3ChannelPayload.AckPayload> ackPayload;
                        SkinProperty skinProperty;
                        SRServerPluginMessage.SkinUpdateV3ChannelPayload $b$2 = (SRServerPluginMessage.SkinUpdateV3ChannelPayload)selector3$temp;
                        {
                            Optional<SRServerPluginMessage.SkinUpdateV3ChannelPayload.AckPayload> patt8$temp;
                            SkinProperty patt7$temp;
                            skinProperty = patt7$temp = $b$2.skinProperty();
                            ackPayload = patt8$temp = $b$2.ackPayload();
                        }
                        runnable = () -> {
                            this.skinApplier.applySkin(event.getPlayer().getAs(Object.class), skinProperty);
                            ackPayload.ifPresent(value -> {
                                if (value.proxySrVersion().equalsIgnoreCase(BuildData.VERSION)) {
                                    this.logger.debug(J_L_String.formatted("Proxy version %s matches server version %s.", value.proxySrVersion(), BuildData.VERSION));
                                } else {
                                    this.logger.warning(J_L_String.formatted("The proxy is running a different version of SkinsRestorer (%s) than this server (%s). Make sure both proxy and server run the latest version of SkinsRestorer. %s", value.proxySrVersion(), BuildData.VERSION, "https://modrinth.com/plugin/skinsrestorer"));
                                }
                                event.getPlayer().sendToMessageChannel(new SRProxyPluginMessage(new SRProxyPluginMessage.AckChannelPayload(value.ackId(), BuildData.VERSION)));
                            });
                        };
                        return runnable;
                    }
                    case 3: {
                        SRServerPluginMessage.GiveSkullChannelPayload payload = (SRServerPluginMessage.GiveSkullChannelPayload)selector3$temp;
                        runnable = () -> this.serverAdapter.giveSkullItem(event.getPlayer(), payload);
                        return runnable;
                    }
                    case 4: 
                }
                SRServerPluginMessage.UnknownChannelPayload ignored = (SRServerPluginMessage.UnknownChannelPayload)selector3$temp;
                runnable = () -> this.logger.warning(J_L_String.formatted("Received unknown channel payload from proxy (Make sure the server and proxy are running the same version of SkinsRestorer) %s", "https://modrinth.com/plugin/skinsrestorer"));
                return runnable;
            });
        });
    }

    @Inject
    @Generated
    public SRServerMessageAdapter(SRLogger logger, SRServerAdapter serverAdapter, SharedSkinApplier<Object> skinApplier) {
        this.logger = logger;
        this.serverAdapter = serverAdapter;
        this.skinApplier = skinApplier;
    }

    private static /* synthetic */ int jvmdowngrader$switch$lambda$handlePluginMessage$7$0(Object object, int n) {
        int n2;
        if (n < 0 || n >= 5) {
            throw new IndexOutOfBoundsException(SRServerMessageAdapter.jvmdowngrader$concat$jvmdowngrader$switch$lambda$handlePluginMessage$7$0$1(n, 5));
        }
        if (object == null) {
            n2 = -1;
        } else {
            switch (n) {
                case 0: {
                    if (object instanceof SRServerPluginMessage.GUIPageChannelPayload) {
                        n2 = 0;
                        break;
                    }
                }
                case 1: {
                    if (object instanceof SRServerPluginMessage.SkinUpdateV2ChannelPayload) {
                        n2 = 1;
                        break;
                    }
                }
                case 2: {
                    if (object instanceof SRServerPluginMessage.SkinUpdateV3ChannelPayload) {
                        n2 = 2;
                        break;
                    }
                }
                case 3: {
                    if (object instanceof SRServerPluginMessage.GiveSkullChannelPayload) {
                        n2 = 3;
                        break;
                    }
                }
                case 4: {
                    if (object instanceof SRServerPluginMessage.UnknownChannelPayload) {
                        n2 = 4;
                        break;
                    }
                }
                default: {
                    n2 = 5;
                }
            }
        }
        return n2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$jvmdowngrader$switch$lambda$handlePluginMessage$7$0$1(int n, int n2) {
        return "Index " + n + " out of bounds for length " + n2;
    }
}

