/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.floodgate;

import java.util.UUID;
import java.util.function.Consumer;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shared.floodgate.FloodgateListener;
import net.skinsrestorer.shared.log.SRLogger;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;

public class FloodgateUtil {
    public static boolean isFloodgateBedrockPlayer(UUID uuid) {
        try {
            return FloodgateApi.getInstance().isFloodgateId(uuid);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void registerListener(Injector injector) {
        SRLogger logger = injector.getSingleton(SRLogger.class);
        try {
            FloodgateApi.getInstance().getEventBus().subscribe(SkinApplyEvent.class, (Consumer)injector.getSingleton(FloodgateListener.class));
            logger.info("Floodgate skin listener registered");
        }
        catch (Throwable t) {
            logger.severe("Failed to register Floodgate skin listener (Is floodgate and SkinsRestorer up to date?)", t);
        }
    }
}

