/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.floodgate;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shared.log.SRLogger;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={SkinDataImpl.class})
public class FloodgateListener
implements Consumer<SkinApplyEvent> {
    private final SRLogger logger;
    private final PlayerStorage playerStorage;

    @Override
    public void accept(SkinApplyEvent event) {
        FloodgatePlayer floodgatePlayer = event.player();
        this.logger.debug(J_L_String.formatted("Handling Floodgate skin apply for %s (%s)", floodgatePlayer.getCorrectUsername(), floodgatePlayer.getCorrectUniqueId()));
        try {
            Optional<SkinProperty> optional = this.playerStorage.getSkinForPlayer(floodgatePlayer.getCorrectUniqueId(), floodgatePlayer.getCorrectUsername(), true);
            optional.ifPresent(skinProperty -> event.newSkin((SkinApplyEvent.SkinData)new SkinDataImpl(skinProperty.getValue(), skinProperty.getSignature())));
        }
        catch (DataRequestException e) {
            this.logger.warning(J_L_String.formatted("Failed to get skin for %s (%s)", floodgatePlayer.getCorrectUsername(), floodgatePlayer.getCorrectUniqueId()), e);
        }
    }

    @Inject
    @Generated
    public FloodgateListener(SRLogger logger, PlayerStorage playerStorage) {
        this.logger = logger;
        this.playerStorage = playerStorage;
    }

    @RecordComponents(value={@RecordComponents.Value(name="value", type=String.class), @RecordComponents.Value(name="signature", type=String.class)})
    @NestHost(value=FloodgateListener.class)
    private static final class SkinDataImpl
    extends J_L_Record
    implements SkinApplyEvent.SkinData {
        private final String value;
        private final String signature;

        SkinDataImpl(String value, String signature) {
            this.value = value;
            this.signature = signature;
        }

        @Override
        public final String toString() {
            return SkinDataImpl.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return SkinDataImpl.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return SkinDataImpl.jvmdowngrader$equals$equals(this, o);
        }

        public String value() {
            return this.value;
        }

        public String signature() {
            return this.signature;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(SkinDataImpl skinDataImpl) {
            SkinDataImpl skinDataImpl2 = skinDataImpl;
            return "FloodgateListener$SkinDataImpl[" + "value=" + skinDataImpl.value + ", " + "signature=" + skinDataImpl.signature + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(SkinDataImpl skinDataImpl) {
            Object[] objectArray = new Object[]{skinDataImpl.value, skinDataImpl.signature};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(SkinDataImpl skinDataImpl, Object object) {
            if (skinDataImpl == object) {
                return true;
            }
            if (object != null && object instanceof SkinDataImpl) {
                SkinDataImpl skinDataImpl2 = (SkinDataImpl)object;
                if (Objects.equals(skinDataImpl.value, skinDataImpl2.value) && Objects.equals(skinDataImpl.signature, skinDataImpl2.signature)) {
                    return true;
                }
            }
            return false;
        }
    }
}

