/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Map;
import net.skinsrestorer.shared.connections.MojangAPIImpl;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={ServiceCheckResponse.class, ServiceCheckResponse.ServiceCheckMessage.class, ServiceCheckResponse.ServiceCheckType.class})
public class ServiceCheckerService {
    private static final Map<String, UUID> PLAYER_MAP = J_U_Map.ofEntries(J_U_Map.entry("xknat", UUID.fromString("7dcfc130-344a-4719-9fbe-3176bc2075c6")), J_U_Map.entry("jeb_", UUID.fromString("853c80ef-3c37-49fd-aa49-938b674adae6")), J_U_Map.entry("Dinnerbone", UUID.fromString("61699b2e-d327-4a01-9f1e-0ea8c3f06bc6")), J_U_Map.entry("Grumm", UUID.fromString("e6b5c088-0680-44df-9e1b-9bf11792291b")));
    private static final String MESSAGE_ERROR = "%s <red>\u2718 Error getting %s";
    private static final String MESSAGE_ERROR_EXCEPTION = "%s <red>\u2718 Error getting %s: %s";
    private static final String UUID_MESSAGE = "%s <green>\u2714 %s UUID: <aqua>%s";
    private static final String PROFILE_MESSAGE = "%s <green>\u2714 %s Profile: <aqua>%s";
    private final MojangAPIImpl mojangAPI;
    private final SRLogger logger;

    public ServiceCheckResponse checkServices() {
        Optional<UUID> uuid;
        ServiceCheckResponse response = new ServiceCheckResponse();
        Map.Entry<String, UUID> selectedUser = SRHelpers.getRandomEntry(PLAYER_MAP.entrySet());
        String selectedUsername = selectedUser.getKey();
        UUID selectedUUID = selectedUser.getValue();
        try {
            uuid = this.mojangAPI.getUUIDMojang(selectedUsername);
            if (uuid.isPresent()) {
                response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(UUID_MESSAGE, "Mojang", selectedUsername, uuid.get()), true, ServiceCheckResponse.ServiceCheckType.UUID);
            } else {
                response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(MESSAGE_ERROR, "Mojang", "UUID"), false, ServiceCheckResponse.ServiceCheckType.UUID);
            }
        }
        catch (DataRequestException e) {
            this.logger.debug("Error getting Mojang UUID", e);
            response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(MESSAGE_ERROR_EXCEPTION, "Mojang", "UUID", e.getMessage()), false, ServiceCheckResponse.ServiceCheckType.UUID);
        }
        try {
            uuid = this.mojangAPI.getUUIDEclipse(selectedUsername);
            if (uuid.isPresent()) {
                response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(UUID_MESSAGE, "Eclipse", selectedUsername, uuid.get()), true, ServiceCheckResponse.ServiceCheckType.UUID);
            } else {
                response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(MESSAGE_ERROR, "Eclipse", "UUID"), false, ServiceCheckResponse.ServiceCheckType.UUID);
            }
        }
        catch (DataRequestException e) {
            this.logger.debug("Error getting Eclipse UUID", e);
            response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(MESSAGE_ERROR_EXCEPTION, "Eclipse", "UUID", e.getMessage()), false, ServiceCheckResponse.ServiceCheckType.UUID);
        }
        try {
            Optional<SkinProperty> mojang = this.mojangAPI.getProfileMojang(selectedUUID);
            if (mojang.isPresent()) {
                response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(PROFILE_MESSAGE, "Mojang", selectedUUID, mojang.get()), true, ServiceCheckResponse.ServiceCheckType.PROFILE);
            } else {
                response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(MESSAGE_ERROR, "Mojang", "Profile"), false, ServiceCheckResponse.ServiceCheckType.PROFILE);
            }
        }
        catch (DataRequestException e) {
            this.logger.debug("Error getting Mojang Profile", e);
            response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(MESSAGE_ERROR_EXCEPTION, "Mojang", "Profile", e.getMessage()), false, ServiceCheckResponse.ServiceCheckType.PROFILE);
        }
        try {
            Optional<SkinProperty> eclipse = this.mojangAPI.getProfileEclipse(selectedUUID);
            if (eclipse.isPresent()) {
                response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(PROFILE_MESSAGE, "Eclipse", selectedUUID, eclipse.get()), true, ServiceCheckResponse.ServiceCheckType.PROFILE);
            } else {
                response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(MESSAGE_ERROR, "Eclipse", "Profile"), false, ServiceCheckResponse.ServiceCheckType.PROFILE);
            }
        }
        catch (DataRequestException e) {
            this.logger.debug("Error getting Eclipse Profile", e);
            response.jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(J_L_String.formatted(MESSAGE_ERROR_EXCEPTION, "Eclipse", "Profile", e.getMessage()), false, ServiceCheckResponse.ServiceCheckType.PROFILE);
        }
        return response;
    }

    @Inject
    @Generated
    public ServiceCheckerService(MojangAPIImpl mojangAPI, SRLogger logger) {
        this.mojangAPI = mojangAPI;
        this.logger = logger;
    }

    @NestHost(value=ServiceCheckerService.class)
    public static class ServiceCheckResponse {
        private final List<ServiceCheckMessage> results = new LinkedList<ServiceCheckMessage>();

        public boolean allFullySuccessful() {
            return this.results.stream().allMatch(ServiceCheckMessage::success);
        }

        public boolean minOneServiceUnavailable() {
            for (ServiceCheckType type : ServiceCheckType.values()) {
                if (this.getSuccessCount(type) != 0) continue;
                return true;
            }
            return false;
        }

        public int getSuccessCount(ServiceCheckType type) {
            return (int)this.results.stream().filter(message -> message.type() == type && message.success()).count();
        }

        public int getTotalCount(ServiceCheckType type) {
            return (int)this.results.stream().filter(message -> message.type() == type).count();
        }

        private void addResult(String message, boolean success, ServiceCheckType type) {
            this.results.add(new ServiceCheckMessage(message, success, type));
        }

        @Generated
        public List<ServiceCheckMessage> getResults() {
            return this.results;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$addResult(String string, boolean bl, ServiceCheckType serviceCheckType) {
            this.addResult(string, bl, serviceCheckType);
        }

        @NestHost(value=ServiceCheckerService.class)
        public static enum ServiceCheckType {
            UUID,
            PROFILE;

        }

        @RecordComponents(value={@RecordComponents.Value(name="message", type=String.class), @RecordComponents.Value(name="success", type=boolean.class), @RecordComponents.Value(name="type", type=ServiceCheckType.class)})
        @NestHost(value=ServiceCheckerService.class)
        public static final class ServiceCheckMessage
        extends J_L_Record {
            private final String message;
            private final boolean success;
            private final ServiceCheckType type;

            public ServiceCheckMessage(String message, boolean success, ServiceCheckType type) {
                this.message = message;
                this.success = success;
                this.type = type;
            }

            @Override
            public final String toString() {
                return ServiceCheckMessage.jvmdowngrader$toString$toString(this);
            }

            @Override
            public final int hashCode() {
                return ServiceCheckMessage.jvmdowngrader$hashCode$hashCode(this);
            }

            @Override
            public final boolean equals(Object o) {
                return ServiceCheckMessage.jvmdowngrader$equals$equals(this, o);
            }

            public String message() {
                return this.message;
            }

            public boolean success() {
                return this.success;
            }

            public ServiceCheckType type() {
                return this.type;
            }

            private static /* synthetic */ String jvmdowngrader$toString$toString(ServiceCheckMessage serviceCheckMessage) {
                ServiceCheckMessage serviceCheckMessage2 = serviceCheckMessage;
                return "ServiceCheckerService$ServiceCheckResponse$ServiceCheckMessage[" + "message=" + serviceCheckMessage.message + ", " + "success=" + serviceCheckMessage.success + ", " + "type=" + (Object)((Object)serviceCheckMessage.type) + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(ServiceCheckMessage serviceCheckMessage) {
                Object[] objectArray = new Object[]{serviceCheckMessage.message, serviceCheckMessage.success, serviceCheckMessage.type};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals$equals(ServiceCheckMessage serviceCheckMessage, Object object) {
                if (serviceCheckMessage == object) {
                    return true;
                }
                if (object != null && object instanceof ServiceCheckMessage) {
                    ServiceCheckMessage serviceCheckMessage2 = (ServiceCheckMessage)object;
                    if (Objects.equals(serviceCheckMessage.message, serviceCheckMessage2.message) && serviceCheckMessage.success == serviceCheckMessage2.success && Objects.equals((Object)serviceCheckMessage.type, (Object)serviceCheckMessage2.type)) {
                        return true;
                    }
                }
                return false;
            }

            public /* synthetic */ boolean jvmdowngrader$handleNest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$ServiceCheckMessage$get$success() {
                return this.success;
            }

            public /* synthetic */ void jvmdowngrader$handleNest$net_skinsrestorer_shared_connections_ServiceCheckerService$ServiceCheckResponse$ServiceCheckMessage$set$success(boolean bl) {
                this.success = bl;
            }
        }
    }
}

