/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.gson.reflect.TypeToken;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.connections.responses.uuid.MojangBatchUUIDEntry;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.UUIDUtils;
import net.skinsrestorer.shared.utils.ValidationUtil;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class MojangBatchAPI {
    private static final int DEFAULT_BATCH_SIZE = 10;
    private static final int HTTP_TIMEOUT_MS = 5000;
    private final MetricsCounter metricsCounter;
    private final SRLogger logger;
    private final SRPlatformAdapter adapter;
    private final HttpClient httpClient;
    private final SettingsManager settings;
    private final String batchEndpoint;
    private final String userAgent;
    private final ConcurrentHashMap<String, CompletableFuture<Optional<UUID>>> pendingRequests = new ConcurrentHashMap();
    private final List<String> batchQueue = Collections.synchronizedList(new ArrayList());
    private final AtomicLong lastBatchTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicBoolean batchInProgress = new AtomicBoolean(false);

    public MojangBatchAPI(MetricsCounter metricsCounter, SRLogger logger, SRPlatformAdapter adapter, HttpClient httpClient, SettingsManager settings, String batchEndpoint, String userAgent) {
        this.metricsCounter = metricsCounter;
        this.logger = logger;
        this.adapter = adapter;
        this.httpClient = httpClient;
        this.settings = settings;
        this.batchEndpoint = batchEndpoint;
        this.userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Optional<UUID>> getUUID(String playerName) {
        if (ValidationUtil.invalidMinecraftUsername(playerName)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CompletableFuture<Optional<UUID>> existing = this.pendingRequests.get(playerName.toLowerCase(Locale.ROOT));
        if (existing != null) {
            return existing;
        }
        CompletableFuture<Optional<UUID>> future = new CompletableFuture<Optional<UUID>>();
        this.pendingRequests.put(playerName.toLowerCase(Locale.ROOT), future);
        List<String> list = this.batchQueue;
        synchronized (list) {
            this.batchQueue.add(playerName);
            if (this.batchQueue.size() >= 10) {
                this.scheduleBatch(0L);
            } else {
                long timeSinceLastBatch = System.currentTimeMillis() - this.lastBatchTime.get();
                int windowSeconds = this.settings.getProperty(APIConfig.MOJANG_BATCH_WINDOW_SECONDS);
                long delay = Math.max(0L, TimeUnit.SECONDS.toMillis(windowSeconds) - timeSinceLastBatch);
                this.scheduleBatch(delay);
            }
        }
        return future;
    }

    private void scheduleBatch(long delayMillis) {
        this.adapter.runAsyncDelayed(this::processBatch, delayMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBatch() {
        ArrayList<String> namesToProcess;
        if (!this.batchInProgress.compareAndSet(false, true)) {
            return;
        }
        List<String> list = this.batchQueue;
        synchronized (list) {
            if (this.batchQueue.isEmpty()) {
                this.batchInProgress.set(false);
                return;
            }
            namesToProcess = new ArrayList<String>(this.batchQueue);
            this.batchQueue.clear();
        }
        this.lastBatchTime.set(System.currentTimeMillis());
        try {
            List<Optional<UUID>> results = this.sendBatchRequest(namesToProcess);
            for (int i = 0; i < namesToProcess.size(); ++i) {
                String name = (String)namesToProcess.get(i);
                Optional result = i < results.size() ? results.get(i) : Optional.empty();
                CompletableFuture<Optional<UUID>> future = this.pendingRequests.remove(name.toLowerCase(Locale.ROOT));
                if (future == null) continue;
                future.complete(result);
            }
        }
        catch (Exception e) {
            this.logger.debug("Error processing batch request", e);
            for (String name : namesToProcess) {
                CompletableFuture<Optional<UUID>> future = this.pendingRequests.remove(name.toLowerCase(Locale.ROOT));
                if (future == null) continue;
                future.complete(Optional.empty());
            }
        }
        finally {
            this.batchInProgress.set(false);
        }
    }

    private List<Optional<UUID>> sendBatchRequest(List<String> names) throws DataRequestExceptionShared {
        if (names.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> batchNames = names.size() > 10 ? names.subList(0, 10) : names;
        Gson gson = new Gson();
        HttpClient.RequestBody requestBody = new HttpClient.RequestBody(gson.toJson(batchNames), HttpClient.HttpType.JSON);
        try {
            HttpResponse httpResponse = this.httpClient.execute(URI.create(this.batchEndpoint), requestBody, HttpClient.HttpType.JSON, this.userAgent, HttpClient.HttpMethod.POST, Collections.emptyMap(), 5000);
            this.metricsCounter.increment(MetricsCounter.Service.MOJANG_UUID);
            if (httpResponse.statusCode() == 200 && !httpResponse.body().isEmpty()) {
                List entries = (List)httpResponse.getBodyAs(new TypeToken<List<MojangBatchUUIDEntry>>(this){}.getType());
                return this.processBatchResponse(entries, batchNames);
            }
            if (httpResponse.statusCode() == 429) {
                throw new DataRequestExceptionShared("Please wait a minute before requesting that skin again. (Rate Limited)");
            }
            this.logger.debug(MojangBatchAPI.jvmdowngrader$concat$sendBatchRequest$1(httpResponse.statusCode()));
            return Collections.nCopies(batchNames.size(), Optional.empty());
        }
        catch (IOException e) {
            this.logger.debug("Error sending batch request", e);
            throw new DataRequestExceptionShared(e);
        }
        catch (DataRequestException e) {
            this.logger.debug("Error parsing batch response", e);
            throw new DataRequestExceptionShared(e);
        }
    }

    private List<Optional<UUID>> processBatchResponse(List<MojangBatchUUIDEntry> entries, List<String> requestedNames) {
        UUID uuid;
        ArrayList<Optional<UUID>> results = new ArrayList<Optional<UUID>>();
        HashMap<String, UUID> nameToUuid = new HashMap<String, UUID>();
        if (entries != null) {
            for (MojangBatchUUIDEntry entry : entries) {
                if (entry.getId() == null || entry.getName() == null) continue;
                try {
                    uuid = UUIDUtils.convertToDashed(entry.getId());
                    nameToUuid.put(entry.getName().toLowerCase(Locale.ROOT), uuid);
                }
                catch (Exception e) {
                    this.logger.debug(MojangBatchAPI.jvmdowngrader$concat$processBatchResponse$1(entry.getId()), e);
                }
            }
        }
        for (String name : requestedNames) {
            uuid = (UUID)nameToUuid.get(name.toLowerCase(Locale.ROOT));
            results.add(Optional.ofNullable(uuid));
        }
        return results;
    }

    private static /* synthetic */ String jvmdowngrader$concat$sendBatchRequest$1(int n) {
        return "Batch request failed with status: " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processBatchResponse$1(String string) {
        return "Invalid UUID format: " + string;
    }
}

