/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.context.CommandInput;
import net.skinsrestorer.shadow.cloud.parser.ArgumentParseResult;
import net.skinsrestorer.shadow.cloud.parser.ArgumentParser;
import net.skinsrestorer.shadow.cloud.suggestion.BlockingSuggestionProvider;
import net.skinsrestorer.shadow.cloud.suggestion.Suggestion;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shared.commands.library.PlayerSelector;
import net.skinsrestorer.shared.commands.library.SRMessageException;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.utils.UUIDUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlayerSelectorArgumentParser
implements ArgumentParser<SRCommandSender, PlayerSelector>,
BlockingSuggestionProvider<SRCommandSender> {
    private final SRPlatformAdapter platform;

    @Override
    public @NonNull ArgumentParseResult<PlayerSelector> parse(@NonNull CommandContext<@NonNull SRCommandSender> commandContext, @NonNull CommandInput commandInput) {
        int start = commandInput.cursor();
        String string = commandInput.readString();
        int current = commandInput.cursor();
        Collection<SRPlayer> players = this.platform.getOnlinePlayers(commandContext.sender());
        ArrayList<PlayerSelector.Resolvable> toResolve = new ArrayList<PlayerSelector.Resolvable>();
        boolean isFirst = true;
        for (String requestedPlayer : string.split("\\+")) {
            current = isFirst ? (current += requestedPlayer.length()) : (current += requestedPlayer.length() + 1);
            isFirst = false;
            if (requestedPlayer.equalsIgnoreCase("-all")) {
                toResolve.add(new PlayerSelector.Selector(this.platform, PlayerSelector.SelectorType.ALL_PLAYERS));
                continue;
            }
            if (requestedPlayer.equalsIgnoreCase("-random")) {
                toResolve.add(new PlayerSelector.Selector(this.platform, PlayerSelector.SelectorType.RANDOM_PLAYER));
                continue;
            }
            Optional<UUID> parsedUniqueId = UUIDUtils.tryParseUniqueId(requestedPlayer);
            if (parsedUniqueId.isPresent()) {
                toResolve.add(new PlayerSelector.UniqueId(parsedUniqueId.get()));
                continue;
            }
            Optional<SRPlayer> exactPlayer = players.stream().filter(p -> p.getName().equals(requestedPlayer)).findFirst();
            if (exactPlayer.isPresent()) {
                toResolve.add(new PlayerSelector.Player(exactPlayer.get()));
                continue;
            }
            Optional<SRPlayer> player = players.stream().filter(p -> p.getName().equalsIgnoreCase(requestedPlayer)).findFirst();
            if (player.isPresent()) {
                toResolve.add(new PlayerSelector.Player(player.get()));
                continue;
            }
            commandInput.cursor(current - requestedPlayer.length());
            return ArgumentParseResult.failure(new SRMessageException(locale -> locale.getMessageRequired((SRForeign)commandContext.sender(), Message.COMMAND_UNKNOWN_PLAYER, Placeholder.unparsed("name", requestedPlayer))));
        }
        if (!toResolve.isEmpty()) {
            return ArgumentParseResult.success(new PlayerSelector(toResolve));
        }
        commandInput.cursor(start);
        return ArgumentParseResult.failure(new SRMessageException(locale -> locale.getMessageRequired((SRForeign)commandContext.sender(), Message.COMMAND_NO_TARGETS_SUPPLIED)));
    }

    @Override
    public @NonNull Iterable<? extends @NonNull Suggestion> suggestions(@NonNull CommandContext<SRCommandSender> context, @NonNull CommandInput input) {
        List<String> usableNames = J_U_S_Stream.toList(Stream.concat(Stream.of("-all", "-random"), this.platform.getOnlinePlayers(context.sender()).stream().filter(player -> {
            SRPlayer sourcePlayer;
            Object patt0$temp = context.sender();
            return !(patt0$temp instanceof SRPlayer) || (sourcePlayer = (SRPlayer)patt0$temp).canSee((SRPlayer)player);
        }).map(SRPlayer::getName)));
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        int lastSeparator = input.remainingInput().lastIndexOf(43);
        String lastInput = lastSeparator == -1 ? input.remainingInput() : input.remainingInput().substring(lastSeparator + 1);
        String otherInput = lastSeparator == -1 ? "" : input.remainingInput().substring(0, lastSeparator + 1);
        for (String name : usableNames) {
            if (!name.toLowerCase(Locale.ROOT).startsWith(lastInput.toLowerCase(Locale.ROOT))) continue;
            suggestions.add(Suggestion.suggestion(PlayerSelectorArgumentParser.jvmdowngrader$concat$suggestions$1(otherInput, name)));
        }
        return suggestions;
    }

    @Generated
    public PlayerSelectorArgumentParser(SRPlatformAdapter platform) {
        this.platform = platform;
    }

    private static /* synthetic */ String jvmdowngrader$concat$suggestions$1(String string, String string2) {
        return string + string2;
    }
}

