/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.config.DevConfig;
import net.skinsrestorer.shared.connections.DumpService;
import net.skinsrestorer.shared.connections.ServiceCheckerService;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.Message;

public class SRCommandService {
    private final SRPlatformAdapter adapter;
    private final ServiceCheckerService serviceCheckerService;
    private final SettingsManager settings;
    private final SRLogger logger;
    private final DumpService dumpService;
    private final Injector injector;

    public void executeStatus(SRCommandSender sender) {
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_CHECKING);
        sender.sendMessage(Message.DIVIDER);
        ServiceCheckerService.ServiceCheckResponse response = this.serviceCheckerService.checkServices();
        for (ServiceCheckerService.ServiceCheckResponse.ServiceCheckMessage message : response.getResults()) {
            if (message.success() && !this.settings.getProperty(DevConfig.DEBUG).booleanValue()) continue;
            sender.sendMessage(ComponentHelper.parseMiniMessageToJsonString(message.message(), new TagResolver[0]));
        }
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_UUID_API, Placeholder.parsed("count", String.valueOf(response.getSuccessCount(ServiceCheckerService.ServiceCheckResponse.ServiceCheckType.UUID))), Placeholder.parsed("total", String.valueOf(response.getTotalCount(ServiceCheckerService.ServiceCheckResponse.ServiceCheckType.UUID))));
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_PROFILE_API, Placeholder.parsed("count", String.valueOf(response.getSuccessCount(ServiceCheckerService.ServiceCheckResponse.ServiceCheckType.PROFILE))), Placeholder.parsed("total", String.valueOf(response.getTotalCount(ServiceCheckerService.ServiceCheckResponse.ServiceCheckType.PROFILE))));
        if (response.allFullySuccessful()) {
            sender.sendMessage(Message.ADMINCOMMAND_STATUS_WORKING);
        } else if (response.minOneServiceUnavailable()) {
            sender.sendMessage(Message.ADMINCOMMAND_STATUS_BROKEN);
            sender.sendMessage(Message.ADMINCOMMAND_STATUS_FIREWALL);
        } else {
            sender.sendMessage(Message.ADMINCOMMAND_STATUS_DEGRADED);
        }
        sender.sendMessage(Message.DIVIDER);
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_VERSION, Placeholder.parsed("version", BuildData.VERSION));
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_SERVER, Placeholder.parsed("version", this.adapter.getPlatformVersion()));
        SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
        if (serverPlugin != null) {
            sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_PROXYMODE, Placeholder.parsed("proxy_mode", Boolean.toString(serverPlugin.isProxyMode())));
        }
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_COMMIT, Placeholder.parsed("hash", BuildData.COMMIT_SHORT));
        sender.sendMessage(Message.DIVIDER);
    }

    public void executeDump(SRCommandSender sender) {
        try {
            sender.sendMessage(Message.ADMINCOMMAND_DUMP_UPLOADING);
            Optional<String> url = this.dumpService.dump();
            if (url.isPresent()) {
                sender.sendMessage(Message.ADMINCOMMAND_DUMP_SUCCESS, Placeholder.parsed("url", J_L_String.formatted("https://bytebin.lucko.me/%s", url.get())));
            } else {
                sender.sendMessage(Message.ADMINCOMMAND_DUMP_ERROR);
            }
        }
        catch (IOException | DataRequestException e) {
            this.logger.severe("Failed to dump data", e);
            sender.sendMessage(Message.ADMINCOMMAND_DUMP_ERROR);
        }
    }

    @Inject
    @Generated
    public SRCommandService(SRPlatformAdapter adapter, ServiceCheckerService serviceCheckerService, SettingsManager settings, SRLogger logger, DumpService dumpService, Injector injector) {
        this.adapter = adapter;
        this.serviceCheckerService = serviceCheckerService;
        this.settings = settings;
        this.logger = logger;
        this.dumpService = dumpService;
        this.injector = injector;
    }
}

