/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import java.util.List;
import lombok.Generated;
import net.skinsrestorer.shadow.cloud.help.result.CommandEntry;
import net.skinsrestorer.shadow.cloud.minecraft.extras.MinecraftHelp;
import net.skinsrestorer.shadow.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shared.commands.library.SRCommandManager;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;

public class CommandHelpService {
    private final SRCommandManager commandManager;
    private final SkinsRestorerLocale locale;

    public void sendRootHelp(SRCommandSender sender, String commandName) {
        MinecraftHelp.builder().commandManager(this.commandManager.getCommandManager()).audienceProvider(ComponentHelper::commandSenderToAudience).commandPrefix(J_L_String.formatted("/%s help", commandName)).messageProvider(MinecraftHelp.captionMessageProvider(this.commandManager.getCommandManager().captionRegistry(), ComponentCaptionFormatter.miniMessage())).descriptionDecorator((s, d) -> ComponentHelper.convertJsonToComponent(this.locale.getMessageRequired((SRForeign)s, J_U_Optional.orElseThrow(Message.fromKey(d))))).commandFilter(c -> c.rootComponent().name().equals(commandName) && !c.commandDescription().description().isEmpty()).maxResultsPerPage(Integer.MAX_VALUE).build().queryCommands("", sender);
    }

    public void sendQueryHelp(SRCommandSender sender, String commandName, String query) {
        MinecraftHelp.builder().commandManager(this.commandManager.getCommandManager()).audienceProvider(ComponentHelper::commandSenderToAudience).commandPrefix(J_L_String.formatted("/%s help", commandName)).messageProvider(MinecraftHelp.captionMessageProvider(this.commandManager.getCommandManager().captionRegistry(), ComponentCaptionFormatter.miniMessage())).descriptionDecorator((s, d) -> ComponentHelper.convertJsonToComponent(this.locale.getMessageRequired((SRForeign)s, J_U_Optional.orElseThrow(Message.fromKey(d))))).commandFilter(c -> c.rootComponent().name().equals(commandName) && !c.commandDescription().description().isEmpty()).build().queryCommands(query == null ? "" : query, sender);
    }

    public List<String> suggestHelpQueries(SRCommandSender sender, String commandName) {
        return J_U_S_Stream.toList(this.commandManager.getCommandManager().createHelpHandler().queryRootIndex(sender).entries().stream().filter(e -> e.command().rootComponent().name().equals(commandName)).map(CommandEntry::syntax));
    }

    @Inject
    @Generated
    public CommandHelpService(SRCommandManager commandManager, SkinsRestorerLocale locale) {
        this.commandManager = commandManager;
        this.locale = locale;
    }
}

