/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.util.List;
import lombok.Generated;
import net.skinsrestorer.shadow.cloud.annotation.specifier.Greedy;
import net.skinsrestorer.shadow.cloud.annotations.Argument;
import net.skinsrestorer.shadow.cloud.annotations.Command;
import net.skinsrestorer.shadow.cloud.annotations.suggestion.Suggestions;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.commands.library.CommandHelpService;
import net.skinsrestorer.shared.commands.library.SRCommandService;
import net.skinsrestorer.shared.commands.library.annotations.CommandDescription;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.RootDescription;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;

@Command(value="sr|skinsrestorer")
@RootDescription(value=Message.HELP_SR)
public final class SRProxyCommand {
    private final CommandHelpService helpService;
    private final SRCommandService srCommandService;

    @Command(value="")
    @CommandPermission(value=PermissionRegistry.SR)
    public void rootCommand(SRCommandSender sender) {
        this.helpService.sendRootHelp(sender, "sr");
    }

    @Suggestions(value="help_queries_sr")
    public List<String> suggestHelpQueries(CommandContext<SRCommandSender> ctx, String input) {
        return this.helpService.suggestHelpQueries(ctx.sender(), "sr");
    }

    @Command(value="help [query]")
    @CommandPermission(value=PermissionRegistry.SR)
    @CommandDescription(value=Message.HELP_SR)
    public void commandHelp(SRCommandSender sender, @Argument(suggestions="help_queries_sr") @Greedy String query) {
        this.helpService.sendQueryHelp(sender, "sr", query);
    }

    @Command(value="status")
    @CommandPermission(value=PermissionRegistry.SR_STATUS)
    @CommandDescription(value=Message.HELP_SR_STATUS)
    private void onStatus(SRCommandSender sender) {
        this.srCommandService.executeStatus(sender);
    }

    @Command(value="dump")
    @CommandPermission(value=PermissionRegistry.SR_DUMP)
    @CommandDescription(value=Message.HELP_SR_DUMP)
    private void onDump(SRCommandSender sender) {
        this.srCommandService.executeDump(sender);
    }

    @Inject
    @Generated
    public SRProxyCommand(CommandHelpService helpService, SRCommandService srCommandService) {
        this.helpService = helpService;
        this.srCommandService = srCommandService;
    }
}

