/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.model.MojangProfileResponse;
import net.skinsrestorer.api.model.MojangProfileTextureMeta;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.SkinApplier;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.api.storage.CacheStorage;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.shadow.cloud.annotation.specifier.Greedy;
import net.skinsrestorer.shadow.cloud.annotation.specifier.Quoted;
import net.skinsrestorer.shadow.cloud.annotations.Argument;
import net.skinsrestorer.shadow.cloud.annotations.Command;
import net.skinsrestorer.shadow.cloud.annotations.suggestion.Suggestions;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.commands.library.CommandHelpService;
import net.skinsrestorer.shared.commands.library.PlayerSelector;
import net.skinsrestorer.shared.commands.library.SRCommandManager;
import net.skinsrestorer.shared.commands.library.SRCommandService;
import net.skinsrestorer.shared.commands.library.annotations.CommandDescription;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.ConsoleOnly;
import net.skinsrestorer.shared.commands.library.annotations.RootDescription;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.connections.DumpService;
import net.skinsrestorer.shared.connections.ServiceCheckerService;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.storage.HardcodedSkins;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;
import net.skinsrestorer.shared.storage.model.skin.PlayerSkinData;
import net.skinsrestorer.shared.storage.model.skin.URLIndexData;
import net.skinsrestorer.shared.storage.model.skin.URLSkinData;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.Permission;
import net.skinsrestorer.shared.subjects.permissions.PermissionGroup;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.ExpiringSet;
import net.skinsrestorer.shared.utils.SRHelpers;
import net.skinsrestorer.shared.utils.UUIDUtils;
import net.skinsrestorer.shared.utils.ValidationUtil;

@Command(value="sr|skinsrestorer")
@RootDescription(value=Message.HELP_SR)
public final class SRCommand {
    private final ExpiringSet<UUID> quotesHelpCache = new ExpiringSet(5L, TimeUnit.MINUTES);
    private final SRPlugin plugin;
    private final SRPlatformAdapter adapter;
    private final ServiceCheckerService serviceCheckerService;
    private final PlayerStorage playerStorage;
    private final CacheStorage cacheStorage;
    private final SkinStorageImpl skinStorage;
    private final AdapterReference adapterReference;
    private final SettingsManager settings;
    private final SRLogger logger;
    private final DumpService dumpService;
    private final SkinsRestorer skinsRestorer;
    private final MineSkinAPI mineSkinAPI;
    private final SkinApplier<Object> skinApplier;
    private final Injector injector;
    private final SkinsRestorerLocale locale;
    private final SRCommandManager commandManager;
    private final CommandHelpService helpService;
    private final SRCommandService srCommandService;

    @Command(value="")
    @CommandPermission(value=PermissionRegistry.SR)
    public void rootCommand(SRCommandSender sender) {
        this.helpService.sendRootHelp(sender, "sr");
    }

    @Suggestions(value="help_queries_sr")
    public List<String> suggestHelpQueries(CommandContext<SRCommandSender> ctx, String input) {
        return this.helpService.suggestHelpQueries(ctx.sender(), "sr");
    }

    @Command(value="help [query]")
    @CommandPermission(value=PermissionRegistry.SR)
    @CommandDescription(value=Message.HELP_SR)
    public void commandHelp(SRCommandSender sender, @Argument(suggestions="help_queries_sr") @Greedy String query) {
        this.helpService.sendQueryHelp(sender, "sr", query);
    }

    @Command(value="reload")
    @CommandPermission(value=PermissionRegistry.SR_RELOAD)
    @CommandDescription(value=Message.HELP_SR_RELOAD)
    private void onReload(SRCommandSender sender) {
        this.plugin.loadConfig();
        try {
            this.plugin.loadLocales();
        }
        catch (IOException e) {
            this.logger.severe("Failed to load locales", e);
        }
        try {
            this.plugin.loadStorage();
        }
        catch (InitializeException e) {
            this.logger.severe("Failed to load storage", e);
        }
        sender.sendMessage(Message.SUCCESS_ADMIN_RELOAD);
    }

    @Command(value="docs permissions")
    @CommandPermission(value=PermissionRegistry.SR)
    private void onDocsPermissions(SRCommandSender sender) {
        for (PermissionRegistry permissionRegistry : PermissionRegistry.values()) {
            sender.sendMessage(ComponentHelper.convertComponentToJson(Component.text(J_L_String.formatted("| `%s` | %s |", permissionRegistry.getPermission().getPermissionString(), ComponentHelper.convertComponentToPlain(ComponentHelper.convertJsonToComponent(this.locale.getMessageRequired(sender, permissionRegistry.getDescription())))))));
        }
        for (Enum enum_ : PermissionGroup.VALUES) {
            sender.sendMessage(ComponentHelper.convertComponentToJson(Component.text(J_L_String.formatted("| `%s` / `%s` | %s | %s |", ((PermissionGroup)enum_).getBasePermission().getPermissionString(), ((PermissionGroup)enum_).getWildcard().getPermissionString(), ComponentHelper.convertComponentToPlain(ComponentHelper.convertJsonToComponent(this.locale.getMessageRequired(sender, ((PermissionGroup)enum_).getDescription()))), Stream.concat(Arrays.stream(((PermissionGroup)enum_).getParents()).map(PermissionGroup::getBasePermission), Arrays.stream(((PermissionGroup)enum_).getPermissions()).map(PermissionRegistry::getPermission)).map(Permission::getPermissionString).map(arg_0 -> SRCommand.lambda$onDocsPermissions$0("`%s`", arg_0)).collect(Collectors.joining(", "))))));
        }
    }

    @Command(value="status")
    @CommandPermission(value=PermissionRegistry.SR_STATUS)
    @CommandDescription(value=Message.HELP_SR_STATUS)
    private void onStatus(SRCommandSender sender) {
        this.srCommandService.executeStatus(sender);
    }

    @Command(value="drop|remove player <target>")
    @CommandPermission(value=PermissionRegistry.SR_DROP)
    @CommandDescription(value=Message.HELP_SR_DROP)
    private void onDropPlayer(SRCommandSender sender, String target) {
        try {
            Optional<UUID> targetId = this.cacheStorage.getUUID(target, false);
            if (J_U_Optional.isEmpty(targetId)) {
                sender.sendMessage(Message.ADMINCOMMAND_DROP_PLAYER_NOT_FOUND, Placeholder.unparsed("player", target));
                return;
            }
            this.playerStorage.removeSkinIdOfPlayer(targetId.get());
        }
        catch (DataRequestException e) {
            sender.sendMessage(Message.ADMINCOMMAND_DROP_UUID_ERROR);
            return;
        }
        sender.sendMessage(Message.SUCCESS_ADMIN_DROP, Placeholder.unparsed("type", "player"), Placeholder.unparsed("target", target));
    }

    @Command(value="drop|remove skin <target>")
    @CommandPermission(value=PermissionRegistry.SR_DROP)
    @CommandDescription(value=Message.HELP_SR_DROP)
    private void onDropSkin(SRCommandSender sender, String target) {
        Optional<InputDataResult> optional = this.skinStorage.findSkinData(target);
        if (J_U_Optional.isEmpty(optional)) {
            sender.sendMessage(Message.ADMINCOMMAND_DROP_SKIN_NOT_FOUND, Placeholder.unparsed("skin", target));
            return;
        }
        InputDataResult result = optional.get();
        this.skinStorage.removeSkinData(result.getIdentifier());
        sender.sendMessage(Message.SUCCESS_ADMIN_DROP, Placeholder.unparsed("type", "skin"), Placeholder.unparsed("target", target));
    }

    @Command(value="info|props|lookup player <input>")
    @CommandPermission(value=PermissionRegistry.SR_INFO)
    @CommandDescription(value=Message.HELP_SR_INFO)
    private void onInfoPlayer(SRCommandSender sender, String input) {
        sender.sendMessage(Message.ADMINCOMMAND_INFO_CHECKING);
        sender.sendMessage(Message.DIVIDER);
        this.getPlayerInfoMessage(input).accept(sender);
        sender.sendMessage(Message.DIVIDER);
    }

    @Command(value="info|props|lookup skin <input>")
    @CommandPermission(value=PermissionRegistry.SR_INFO)
    @CommandDescription(value=Message.HELP_SR_INFO)
    private void onInfoSkin(SRCommandSender sender, String input) {
        try {
            Consumer<SRCommandSender> message = this.getSkinInfoMessage(input);
            sender.sendMessage(Message.ADMINCOMMAND_INFO_CHECKING);
            sender.sendMessage(Message.DIVIDER);
            message.accept(sender);
            sender.sendMessage(Message.DIVIDER);
        }
        catch (DataRequestException | StorageAdapter.StorageException e) {
            this.logger.severe("Failed to get data", e);
            sender.sendMessage(Message.ERROR_GENERIC);
        }
    }

    private Consumer<SRCommandSender> getPlayerInfoMessage(String input) {
        Optional<UUID> parsedUniqueId = UUIDUtils.tryParseUniqueId(input);
        if (J_U_Optional.isEmpty(parsedUniqueId)) {
            return sender -> sender.sendMessage(Message.ADMINCOMMAND_INFO_INVALID_UUID);
        }
        Optional<SkinIdentifier> playerSkinData = this.playerStorage.getSkinIdOfPlayer(parsedUniqueId.get());
        return playerSkinData.map(skinData -> sender -> sender.sendMessage(Message.ADMINCOMMAND_INFO_PLAYER, Placeholder.parsed("uuid", ((UUID)parsedUniqueId.get()).toString()), Placeholder.parsed("identifier", skinData.getIdentifier()), Placeholder.parsed("variant", String.valueOf((Object)skinData.getSkinVariant())), Placeholder.parsed("type", skinData.getSkinType().toString()))).orElseGet(() -> sender -> sender.sendMessage(Message.ADMINCOMMAND_INFO_NO_SET_SKIN));
    }

    private void sendGenericSkinInfoMessage(SRCommandSender sender, SkinProperty property) {
        MojangProfileResponse profile = PropertyUtils.getSkinProfileData(property);
        String texturesUrl = PropertyUtils.getSkinTextureUrl(property);
        SkinVariant variant = PropertyUtils.getSkinVariant(property);
        MojangProfileTextureMeta skinMetadata = profile.getTextures().getSKIN().getMetadata();
        long timestamp = profile.getTimestamp();
        String requestTime = SRHelpers.formatEpochMillis(this.settings, timestamp, sender.getLocale());
        sender.sendMessage(Message.ADMINCOMMAND_INFO_GENERIC, Placeholder.parsed("url", texturesUrl), Placeholder.parsed("variant", variant.name().toLowerCase(Locale.ROOT)), Placeholder.parsed("uuid", UUIDUtils.convertToDashed(profile.getProfileId()).toString()), Placeholder.parsed("name", profile.getProfileName()), Placeholder.parsed("request_time", requestTime));
    }

    private Consumer<SRCommandSender> getSkinInfoMessage(String input) throws StorageAdapter.StorageException, DataRequestException {
        if (ValidationUtil.validSkinUrl(input)) {
            Optional<URLIndexData> urlSkinIndex = this.adapterReference.get().getURLSkinIndex(input);
            if (J_U_Optional.isEmpty(urlSkinIndex)) {
                return sender -> sender.sendMessage(Message.NO_SKIN_DATA);
            }
            Optional<URLSkinData> urlSkinData = this.adapterReference.get().getURLSkinData(input, urlSkinIndex.get().getSkinVariant());
            return urlSkinData.map(skinData -> sender -> {
                sender.sendMessage(Message.ADMINCOMMAND_INFO_URL_SKIN, Placeholder.parsed("url", input), Placeholder.parsed("mine_skin_id", ((URLSkinData)urlSkinData.get()).getMineSkinId()));
                this.sendGenericSkinInfoMessage((SRCommandSender)sender, skinData.getProperty());
            }).orElseGet(() -> sender -> sender.sendMessage(Message.NO_SKIN_DATA));
        }
        Optional<InputDataResult> result = HardcodedSkins.getHardcodedSkin(input);
        if (result.isPresent()) {
            return sender -> {
                sender.sendMessage(Message.ADMINCOMMAND_INFO_HARDCODED_SKIN, Placeholder.parsed("skin", ((InputDataResult)result.get()).getIdentifier().getIdentifier()));
                this.sendGenericSkinInfoMessage((SRCommandSender)sender, ((InputDataResult)result.get()).getProperty());
            };
        }
        Optional<CustomSkinData> customSkinData = this.adapterReference.get().getCustomSkinData(input);
        if (customSkinData.isPresent()) {
            return sender -> {
                sender.sendMessage(Message.ADMINCOMMAND_INFO_CUSTOM_SKIN, Placeholder.parsed("skin", input));
                this.sendGenericSkinInfoMessage((SRCommandSender)sender, ((CustomSkinData)customSkinData.get()).getProperty());
            };
        }
        Optional<UUID> uuid = this.cacheStorage.getUUID(input, false);
        if (J_U_Optional.isEmpty(uuid)) {
            return sender -> sender.sendMessage(Message.NO_SKIN_DATA);
        }
        Optional<PlayerSkinData> playerSkinData = this.adapterReference.get().getPlayerSkinData(uuid.get());
        return playerSkinData.map(skinData -> sender -> {
            sender.sendMessage(Message.ADMINCOMMAND_INFO_PLAYER_SKIN, Placeholder.parsed("skin", input), Placeholder.parsed("timestamp", SRHelpers.formatEpochSeconds(this.settings, ((PlayerSkinData)playerSkinData.get()).getTimestamp(), sender.getLocale())), Placeholder.parsed("expires", SRHelpers.formatEpochSeconds(this.settings, ((PlayerSkinData)playerSkinData.get()).getTimestamp() + TimeUnit.MINUTES.toSeconds(this.settings.getProperty(StorageConfig.SKIN_EXPIRES_AFTER).intValue()), sender.getLocale())));
            this.sendGenericSkinInfoMessage((SRCommandSender)sender, skinData.getProperty());
        }).orElseGet(() -> sender -> sender.sendMessage(Message.NO_SKIN_DATA));
    }

    @Command(value="applyskin <selector>")
    @CommandPermission(value=PermissionRegistry.SR_APPLY_SKIN)
    @CommandDescription(value=Message.HELP_SR_APPLY_SKIN)
    private void onApplySkin(SRCommandSender sender, PlayerSelector selector) {
        for (UUID target : selector.resolve(sender)) {
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            if (J_U_Optional.isEmpty(targetPlayer)) continue;
            try {
                this.skinApplier.applySkin(targetPlayer.get().getAs(Object.class));
                sender.sendMessage(Message.SUCCESS_ADMIN_APPLYSKIN, Placeholder.unparsed("player", targetPlayer.get().getName()));
            }
            catch (DataRequestException e) {
                ComponentHelper.sendException(e, sender, this.locale, this.logger);
            }
        }
    }

    @Command(value="createcustom <skinName> <skinInput>")
    @CommandPermission(value=PermissionRegistry.SR_CREATE_CUSTOM)
    @CommandDescription(value=Message.HELP_SR_CREATE_CUSTOM)
    private void onCreateCustom(SRCommandSender sender, String skinName, @Quoted String skinInput) {
        this.createCustom(sender, skinName, skinInput, null);
    }

    @Command(value="createcustom <skinName> <skinInput> <skinVariant>")
    @CommandPermission(value=PermissionRegistry.SR_CREATE_CUSTOM)
    @CommandDescription(value=Message.HELP_SR_CREATE_CUSTOM)
    private void onCreateCustom(SRCommandSender sender, String skinName, @Quoted String skinInput, SkinVariant skinVariant) {
        this.createCustom(sender, skinName, skinInput, skinVariant);
    }

    private void createCustom(SRCommandSender sender, String skinName, @Quoted String skinInput, SkinVariant skinVariant) {
        try {
            Optional<InputDataResult> response = this.skinStorage.findOrCreateSkinData(skinInput, skinVariant);
            if (J_U_Optional.isEmpty(response)) {
                sender.sendMessage(Message.NOT_PREMIUM);
                return;
            }
            this.skinStorage.setCustomSkinData(skinName, response.get().getProperty());
            sender.sendMessage(Message.SUCCESS_ADMIN_CREATECUSTOM, Placeholder.unparsed("skin", skinName));
        }
        catch (DataRequestException | MineSkinException e) {
            ComponentHelper.sendException(e, sender, this.locale, this.logger);
        }
    }

    @Command(value="setcustomname <skinName> <displayName>")
    @CommandPermission(value=PermissionRegistry.SR_CREATE_CUSTOM)
    @CommandDescription(value=Message.HELP_SR_CREATE_CUSTOM)
    private void onSetCustomName(SRCommandSender sender, String skinName, @Greedy String displayName) {
        try {
            ComponentString componentString = ComponentHelper.parseMiniMessageToJsonString(displayName, new TagResolver[0]);
            this.skinStorage.setCustomSkinDisplayName(skinName, componentString);
            sender.sendMessage(Message.SUCCESS_ADMIN_SETCUSTOMNAME, Placeholder.unparsed("skin", skinName), Placeholder.component("display_name", ComponentHelper.convertJsonToComponent(componentString)));
        }
        catch (StorageAdapter.StorageException e) {
            ComponentHelper.sendException(e, sender, this.locale, this.logger);
        }
    }

    @ConsoleOnly
    @Command(value="purgeolddata <days>")
    @CommandPermission(value=PermissionRegistry.SR_PURGE_OLD_DATA)
    @CommandDescription(value=Message.HELP_SR_PURGE_OLD_DATA)
    private void onPurgeOldData(SRCommandSender sender, int days) {
        if (this.skinStorage.purgeOldSkins(days)) {
            sender.sendMessage(Message.ADMINCOMMAND_PURGEOLDDATA_SUCCESS);
        } else {
            sender.sendMessage(Message.ADMINCOMMAND_PURGEOLDDATA_ERROR);
        }
    }

    @Command(value="dump")
    @CommandPermission(value=PermissionRegistry.SR_DUMP)
    @CommandDescription(value=Message.HELP_SR_DUMP)
    private void onDump(SRCommandSender sender) {
        this.srCommandService.executeDump(sender);
    }

    @Inject
    @Generated
    public SRCommand(SRPlugin plugin, SRPlatformAdapter adapter, ServiceCheckerService serviceCheckerService, PlayerStorage playerStorage, CacheStorage cacheStorage, SkinStorageImpl skinStorage, AdapterReference adapterReference, SettingsManager settings, SRLogger logger, DumpService dumpService, SkinsRestorer skinsRestorer, MineSkinAPI mineSkinAPI, SkinApplier<Object> skinApplier, Injector injector, SkinsRestorerLocale locale, SRCommandManager commandManager, CommandHelpService helpService, SRCommandService srCommandService) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.serviceCheckerService = serviceCheckerService;
        this.playerStorage = playerStorage;
        this.cacheStorage = cacheStorage;
        this.skinStorage = skinStorage;
        this.adapterReference = adapterReference;
        this.settings = settings;
        this.logger = logger;
        this.dumpService = dumpService;
        this.skinsRestorer = skinsRestorer;
        this.mineSkinAPI = mineSkinAPI;
        this.skinApplier = skinApplier;
        this.injector = injector;
        this.locale = locale;
        this.commandManager = commandManager;
        this.helpService = helpService;
        this.srCommandService = srCommandService;
    }

    private static /* synthetic */ String lambda$onDocsPermissions$0(String rec$, Object xva$0) {
        return J_L_String.formatted("`%s`", xva$0);
    }
}

