/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import lombok.Generated;
import net.skinsrestorer.shadow.cloud.annotations.Command;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.commands.library.annotations.CommandDescription;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.RootDescription;
import net.skinsrestorer.shared.gui.PageType;
import net.skinsrestorer.shared.gui.SharedGUI;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.storage.GUIStorage;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.MetricsCounter;

public final class GUICommand {
    private final SRPlatformAdapter platformAdapter;
    private final GUIStorage guiStorage;
    private final SharedGUI sharedGUI;
    private final Injector injector;
    private final MetricsCounter metricsCounter;

    @Command(value="skins")
    @RootDescription(value=Message.HELP_SKINS)
    @CommandDescription(value=Message.HELP_SKINS)
    @CommandPermission(value=PermissionRegistry.SKINS)
    private void onDefault(SRPlayer player) {
        player.sendMessage(Message.SKINSMENU_OPEN);
        this.platformAdapter.openGUI(player, this.sharedGUI.createGUIPage(player, this.guiStorage.getGUIPage(player, 0, PageType.SELECT)));
        this.metricsCounter.increment(MetricsCounter.CommandType.SKIN_GUI);
    }

    @Inject
    @Generated
    public GUICommand(SRPlatformAdapter platformAdapter, GUIStorage guiStorage, SharedGUI sharedGUI, Injector injector, MetricsCounter metricsCounter) {
        this.platformAdapter = platformAdapter;
        this.guiStorage = guiStorage;
        this.sharedGUI = sharedGUI;
        this.injector = injector;
        this.metricsCounter = metricsCounter;
    }
}

