/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.api.event;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import net.skinsrestorer.api.event.SkinsRestorerEvent;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="plugin", type=WeakReference.class), @RecordComponents.Value(name="eventClass", type=Class.class), @RecordComponents.Value(name="listener", type=WeakReference.class)})
public final class EventSubscription<E extends SkinsRestorerEvent>
extends J_L_Record {
    private final WeakReference<Object> plugin;
    private final Class<E> eventClass;
    private final WeakReference<Consumer<E>> listener;

    public EventSubscription(WeakReference<Object> plugin, Class<E> eventClass, WeakReference<Consumer<E>> listener) {
        this.plugin = plugin;
        this.eventClass = eventClass;
        this.listener = listener;
    }

    public void callEvent(Object event) {
        if (!this.eventClass.isAssignableFrom(event.getClass())) {
            return;
        }
        Consumer listener = (Consumer)this.listener().get();
        if (listener != null) {
            listener.accept((SkinsRestorerEvent)this.eventClass.cast(event));
        }
    }

    @Override
    public final String toString() {
        return EventSubscription.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return EventSubscription.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return EventSubscription.jvmdowngrader$equals$equals(this, o);
    }

    public WeakReference<Object> plugin() {
        return this.plugin;
    }

    public Class<E> eventClass() {
        return this.eventClass;
    }

    public WeakReference<Consumer<E>> listener() {
        return this.listener;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(EventSubscription eventSubscription) {
        EventSubscription eventSubscription2 = eventSubscription;
        return "EventSubscription[" + "plugin=" + eventSubscription.plugin + ", " + "eventClass=" + eventSubscription.eventClass + ", " + "listener=" + eventSubscription.listener + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(EventSubscription eventSubscription) {
        Object[] objectArray = new Object[]{eventSubscription.plugin, eventSubscription.eventClass, eventSubscription.listener};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(EventSubscription eventSubscription, Object object) {
        if (eventSubscription == object) {
            return true;
        }
        if (object != null && object instanceof EventSubscription) {
            EventSubscription eventSubscription2 = (EventSubscription)object;
            if (Objects.equals(eventSubscription.plugin, eventSubscription2.plugin) && Objects.equals(eventSubscription.eventClass, eventSubscription2.eventClass) && Objects.equals(eventSubscription.listener, eventSubscription2.listener)) {
                return true;
            }
        }
        return false;
    }
}

