/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.xseries.reflection;

import net.skinsrestorer.shadow.jbannotations.ApiStatus;
import net.skinsrestorer.shadow.jbannotations.Contract;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.xseries.reflection.CachedReflectiveHandle;
import net.skinsrestorer.shadow.xseries.reflection.XReflection;
import net.skinsrestorer.shadow.xseries.reflection.jvm.objects.ReflectedObject;

public interface ReflectiveHandle<T> {
    @ApiStatus.Experimental
    @Contract(value="-> new", pure=true)
    public ReflectiveHandle<T> copy();

    @Contract(pure=true)
    default public boolean exists() {
        try {
            this.reflect();
            return true;
        }
        catch (ReflectiveOperationException ignored) {
            return false;
        }
    }

    @Deprecated
    @Nullable
    @ApiStatus.Obsolete
    default public ReflectiveOperationException catchError() {
        try {
            this.reflect();
            return null;
        }
        catch (ReflectiveOperationException ex) {
            return ex;
        }
    }

    @NotNull
    @Contract(pure=true)
    default public T unreflect() {
        try {
            return this.reflect();
        }
        catch (ReflectiveOperationException e) {
            throw XReflection.throwCheckedException(e);
        }
    }

    @Nullable
    @Contract(pure=true)
    default public T reflectOrNull() {
        try {
            return this.reflect();
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @NotNull
    @Contract(pure=true)
    public T reflect() throws ReflectiveOperationException;

    @NotNull
    @ApiStatus.Experimental
    @Contract(pure=true)
    public ReflectiveHandle<ReflectedObject> jvm();

    @NotNull
    @ApiStatus.Experimental
    @Contract(value="-> new", pure=true)
    default public ReflectiveHandle<T> cached() {
        return new CachedReflectiveHandle<T>(this.copy());
    }

    @NotNull
    @ApiStatus.Experimental
    @Contract(pure=true)
    default public ReflectiveHandle<T> unwrap() {
        if (this instanceof CachedReflectiveHandle) {
            return ((CachedReflectiveHandle)this).getDelegate();
        }
        return this;
    }
}

