/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.xseries.base;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;
import net.skinsrestorer.shadow.jbannotations.Contract;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.xseries.base.XModuleMetadata;
import net.skinsrestorer.shadow.xseries.base.XRegistry;

public interface XBase<XForm extends XBase<XForm, BukkitForm>, BukkitForm> {
    @NotNull
    @Contract(pure=true)
    public String name();

    @ApiStatus.Internal
    @Contract(pure=true)
    public String[] getNames();

    @NotNull
    @Contract(pure=true)
    default public String friendlyName() {
        return Arrays.stream(this.name().split("_")).map(t -> t.charAt(0) + t.substring(1).toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" "));
    }

    @Nullable
    @Contract(pure=true)
    public BukkitForm get();

    @Contract(pure=true)
    default public boolean isSupported() {
        return this.get() != null;
    }

    @NotNull
    @Contract(pure=true)
    default public XForm or(XForm other) {
        return (XForm)(this.isSupported() ? this : other);
    }

    @ApiStatus.Internal
    default public XModuleMetadata getMetadata() {
        XRegistry registry = XRegistry.registryOf(this.getClass());
        return registry.getOrRegisterMetadata(this, registry.getBackingField(this), false);
    }
}

