/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.reflect.proxy.internal;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.reflect.bytecode.BytecodeUtils;
import net.skinsrestorer.shadow.reflect.bytecode.builder.BytecodeBuilder;
import net.skinsrestorer.shadow.reflect.bytecode.builder.ClassBuilder;
import net.skinsrestorer.shadow.reflect.bytecode.wrapper.BuiltClass;
import net.skinsrestorer.shadow.reflect.bytecode.wrapper.BytecodeLabel;
import net.skinsrestorer.shadow.reflect.proxy.impl.ProxyMethod;
import net.skinsrestorer.shadow.reflect.proxy.impl.ProxyRuntime;

@ApiStatus.Internal
public class ProxyMethodBuilder {
    private static final BytecodeBuilder BUILDER = BytecodeBuilder.get();

    public static Class<ProxyMethod> buildProxyMethodClass(Class<?> proxyClass, Method method, @Nullable Method originalMethod) {
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_PUBLIC"), BytecodeUtils.slash(proxyClass) + "$ProxyMethodImpl", null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(ProxyMethod.class)}, cb -> {
            ProxyMethodBuilder.addFields(proxyClass, cb);
            ProxyMethodBuilder.addStaticBlock(method, originalMethod, cb);
            ProxyMethodBuilder.addConstructor(proxyClass, cb);
            ProxyMethodBuilder.addMethodGetter(cb);
            ProxyMethodBuilder.addInvokeWith(method, cb);
            ProxyMethodBuilder.addInvokeSuper(proxyClass, originalMethod == null ? method : originalMethod, cb);
            ProxyMethodBuilder.addCancel(method, cb);
        });
        return builtClass.defineAnonymous(proxyClass);
    }

    private static void addFields(Class<?> proxyClass, ClassBuilder cb) {
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_STATIC", "ACC_FINAL"), "INVOKE_OTHER", BytecodeUtils.desc(MethodHandle.class), null, null);
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_STATIC", "ACC_FINAL"), "INVOKE_SUPER", BytecodeUtils.desc(MethodHandle.class), null, null);
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_FINAL"), "instance", BytecodeUtils.desc(proxyClass), null, null);
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_FINAL"), "method", BytecodeUtils.desc(Method.class), null, null);
    }

    private static void addStaticBlock(Method method, @Nullable Method originalMethod, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC", "ACC_STATIC"), "<clinit>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), null, null, mb -> {
            mb.typeLdc(BUILDER, method.getDeclaringClass());
            if (originalMethod != null) {
                mb.typeLdc(BUILDER, originalMethod.getDeclaringClass());
            } else {
                mb.dup();
            }
            mb.ldc(method.getName()).intPush(method.getParameterCount()).anewarray(BytecodeUtils.slash(Class.class));
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> parameter = method.getParameterTypes()[i];
                mb.dup().intPush(i).typeLdc(BUILDER, parameter).aastore();
            }
            mb.typeLdc(BUILDER, method.getReturnType()).invokestatic(BytecodeUtils.slash(ProxyRuntime.class), "getMethodHandles", BytecodeUtils.mdesc(MethodHandle[].class, Class.class, Class.class, String.class, Class[].class, Class.class), false);
            mb.dup().intPush(0).aaload().putstatic(cb.getName(), "INVOKE_OTHER", BytecodeUtils.desc(MethodHandle.class)).intPush(1).aaload().putstatic(cb.getName(), "INVOKE_SUPER", BytecodeUtils.desc(MethodHandle.class));
            mb.return_().maxs(6, 0);
        });
    }

    private static void addConstructor(Class<?> proxyClass, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "<init>", BytecodeUtils.mdesc(Void.TYPE, proxyClass, Method.class), null, null, mb -> mb.aload(0).invokespecial(BytecodeUtils.slash(Object.class), "<init>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), false).aload(0).aload(1).putfield(cb.getName(), "instance", BytecodeUtils.desc(proxyClass)).aload(0).aload(2).putfield(cb.getName(), "method", BytecodeUtils.desc(Method.class)).return_().maxs(3, 3));
    }

    private static void addMethodGetter(ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "getInvokedMethod", BytecodeUtils.mdesc(Method.class, new Class[0]), null, null, mb -> mb.aload(0).getfield(cb.getName(), "method", BytecodeUtils.desc(Method.class)).areturn().maxs(2, 1));
    }

    private static void addInvokeWith(Method method, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "invokeWith", BytecodeUtils.mdesc(Object.class, Object.class, Object[].class), null, null, mb -> {
            String polymorphicSignature = "(" + BytecodeUtils.desc(method.getDeclaringClass());
            for (Class<?> parameter : method.getParameterTypes()) {
                polymorphicSignature = polymorphicSignature + BytecodeUtils.desc(parameter);
            }
            polymorphicSignature = polymorphicSignature + ")" + BytecodeUtils.desc(method.getReturnType());
            mb.getstatic(cb.getName(), "INVOKE_OTHER", BytecodeUtils.desc(MethodHandle.class));
            mb.aload(1).checkcast(BytecodeUtils.slash(method.getDeclaringClass()));
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> parameter = method.getParameterTypes()[i];
                mb.aload(2).intPush(i).aaload().checkcast(BytecodeUtils.slash(BytecodeUtils.boxed(parameter))).unbox(parameter);
            }
            mb.invokevirtual(BytecodeUtils.slash(MethodHandle.class), "invokeExact", polymorphicSignature);
            if (method.getReturnType().equals(Void.TYPE)) {
                mb.aconstNull();
            } else {
                mb.box(method.getReturnType());
            }
            mb.areturn().maxs(method.getParameterCount() + 2, method.getParameterCount() + 1);
        });
    }

    private static void addInvokeSuper(Class<?> proxyClass, Method method, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "invokeSuper", BytecodeUtils.mdesc(Object.class, Object[].class), null, null, mb -> {
            String polymorphicSignature = "(" + BytecodeUtils.desc(method.getDeclaringClass());
            for (Class<?> parameter : method.getParameterTypes()) {
                polymorphicSignature = polymorphicSignature + BytecodeUtils.desc(parameter);
            }
            polymorphicSignature = polymorphicSignature + ")" + BytecodeUtils.desc(method.getReturnType());
            BytecodeLabel elseLabel = mb.newLabel();
            mb.aload(0).getstatic(cb.getName(), "INVOKE_SUPER", BytecodeUtils.desc(MethodHandle.class)).ifnonnull(elseLabel).new_(BytecodeUtils.slash(AbstractMethodError.class)).dup().ldc(BytecodeUtils.slash(method.getDeclaringClass()) + "." + method.getName() + BytecodeUtils.desc(method)).invokespecial(BytecodeUtils.slash(AbstractMethodError.class), "<init>", BytecodeUtils.mdesc(Void.TYPE, String.class), false).athrow().label(elseLabel);
            mb.getstatic(cb.getName(), "INVOKE_SUPER", BytecodeUtils.desc(MethodHandle.class));
            mb.aload(0).getfield(cb.getName(), "instance", BytecodeUtils.desc(proxyClass)).checkcast(BytecodeUtils.slash(method.getDeclaringClass()));
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> parameter = method.getParameterTypes()[i];
                mb.aload(1).intPush(i).aaload().checkcast(BytecodeUtils.slash(BytecodeUtils.boxed(parameter))).unbox(parameter);
            }
            mb.invokevirtual(BytecodeUtils.slash(MethodHandle.class), "invokeExact", polymorphicSignature);
            if (method.getReturnType().equals(Void.TYPE)) {
                mb.aconstNull();
            } else {
                mb.box(method.getReturnType());
            }
            mb.areturn().maxs(method.getParameterCount() + 2, method.getParameterCount() + 1);
        });
    }

    private static void addCancel(Method method, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "cancel", BytecodeUtils.mdesc(Object.class, new Class[0]), null, null, mb -> {
            if (method.getReturnType() == Void.TYPE) {
                mb.aconstNull();
            } else if (method.getReturnType() == Boolean.TYPE) {
                mb.getstatic(BytecodeUtils.slash(Boolean.class), "FALSE", BytecodeUtils.desc(Boolean.class));
            } else if (method.getReturnType() == Byte.TYPE || method.getReturnType() == Short.TYPE || method.getReturnType() == Character.TYPE || method.getReturnType() == Integer.TYPE) {
                mb.intPush(0).box(method.getReturnType());
            } else if (method.getReturnType() == Long.TYPE) {
                mb.ldc(0L).box(method.getReturnType());
            } else if (method.getReturnType() == Float.TYPE) {
                mb.ldc(Float.valueOf(0.0f)).box(method.getReturnType());
            } else if (method.getReturnType() == Double.TYPE) {
                mb.ldc(0.0).box(method.getReturnType());
            } else {
                mb.aconstNull();
            }
            mb.areturn().maxs(1, 1);
        });
    }
}

