/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.reflect.proxy;

import java.lang.reflect.Constructor;
import net.skinsrestorer.shadow.reflect.Constructors;
import net.skinsrestorer.shadow.reflect.Objects;
import net.skinsrestorer.shadow.reflect.exceptions.ConstructorNotFoundException;
import net.skinsrestorer.shadow.reflect.proxy.InvocationHandler;
import net.skinsrestorer.shadow.reflect.proxy.impl.Proxy;

public class ProxyClass {
    private final Class<?> proxyClass;
    private InvocationHandler invocationHandler;

    public ProxyClass(Class<?> proxyClass, InvocationHandler invocationHandler) {
        this.proxyClass = proxyClass;
        this.invocationHandler = invocationHandler;
    }

    public Class<?> getProxyClass() {
        return this.proxyClass;
    }

    public InvocationHandler getInvocationHandler() {
        return this.invocationHandler;
    }

    public void setInvocationHandler(InvocationHandler invocationHandler) {
        this.invocationHandler = invocationHandler;
    }

    public <T> T allocateInstance() {
        Object instance = Objects.allocate(this.proxyClass);
        ((Proxy)instance).setInvocationHandler(this.invocationHandler);
        return (T)instance;
    }

    public <T> T instantiate(Class<?>[] constructorParameters, Object[] constructorArguments) {
        Constructor<?> constructor = Constructors.getDeclaredConstructor(this.proxyClass, constructorParameters);
        if (constructor == null) {
            throw new ConstructorNotFoundException("Proxy", constructorParameters);
        }
        Object instance = Constructors.invoke(constructor, constructorArguments);
        ((Proxy)instance).setInvocationHandler(this.invocationHandler);
        return (T)instance;
    }
}

