/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.reflect.accessor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.skinsrestorer.shadow.javax.annotation.Nonnull;
import net.skinsrestorer.shadow.reflect.Constructors;
import net.skinsrestorer.shadow.reflect.Methods;
import net.skinsrestorer.shadow.reflect.accessor.AccessorUtils;
import net.skinsrestorer.shadow.reflect.bytecode.BytecodeUtils;
import net.skinsrestorer.shadow.reflect.bytecode.builder.BytecodeBuilder;
import net.skinsrestorer.shadow.reflect.bytecode.builder.MethodBuilder;
import net.skinsrestorer.shadow.reflect.bytecode.wrapper.BuiltClass;

public class MethodAccessor {
    private static final BytecodeBuilder BUILDER = BytecodeBuilder.get();

    public static <I> I makeInvoker(@Nonnull Class<I> invokerClass, Object instance, @Nonnull Method method) {
        String newClassName = AccessorUtils.makeAccessorName("MethodInvoker", method.getDeclaringClass(), method.getName());
        boolean staticMethod = Modifier.isStatic(method.getModifiers());
        Method invokerMethod = MethodAccessor.findInvokerMethod(invokerClass, method, false);
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(invokerClass)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, () -> instance.getClass(), staticMethod);
            String methodClass = BytecodeUtils.slash(method.getDeclaringClass());
            String methodDesc = BytecodeUtils.desc(method);
            boolean interfaceMethod = Modifier.isInterface(method.getDeclaringClass().getModifiers());
            cb.method(BUILDER.opcode("ACC_PUBLIC"), invokerMethod.getName(), BytecodeUtils.desc(invokerMethod), null, null, mb -> {
                if (staticMethod) {
                    MethodAccessor.pushArgs(mb, invokerMethod.getParameterTypes(), method.getParameterTypes());
                    mb.invokestatic(methodClass, method.getName(), methodDesc, interfaceMethod);
                } else {
                    mb.aload(0);
                    mb.getfield(newClassName, "instance", BytecodeUtils.desc(instance.getClass()));
                    MethodAccessor.pushArgs(mb, invokerMethod.getParameterTypes(), method.getParameterTypes());
                    if (interfaceMethod) {
                        mb.invokeinterface(methodClass, method.getName(), methodDesc);
                    } else {
                        mb.invokevirtual(methodClass, method.getName(), methodDesc);
                    }
                }
                if (!method.getReturnType().equals(invokerMethod.getReturnType())) {
                    mb.checkcast(BytecodeUtils.slash(invokerMethod.getReturnType()));
                }
                mb.return_(invokerMethod.getReturnType());
                mb.maxs(invokerMethod.getParameterCount() + 1, invokerMethod.getParameterCount() + 1);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(method.getDeclaringClass());
        if (staticMethod) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (I)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (I)Constructors.invoke(constructor, instance);
    }

    public static <R> Function<Object[], R> makeArrayInvoker(Object instance, @Nonnull Method method) {
        String newClassName = AccessorUtils.makeAccessorName("ArrayMethodInvoker", method.getDeclaringClass(), method.getName());
        boolean staticMethod = Modifier.isStatic(method.getModifiers());
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(Function.class)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, () -> instance.getClass(), staticMethod);
            String methodClass = BytecodeUtils.slash(method.getDeclaringClass());
            String methodDesc = BytecodeUtils.desc(method);
            boolean interfaceMethod = Modifier.isInterface(method.getDeclaringClass().getModifiers());
            cb.method(BUILDER.opcode("ACC_PUBLIC"), "apply", BytecodeUtils.mdesc(Object.class, Object.class), null, null, mb -> {
                if (!staticMethod) {
                    mb.aload(0).getfield(cb.getName(), "instance", BytecodeUtils.desc(instance.getClass()));
                }
                MethodAccessor.pushArrayArgs(mb, method, 1);
                if (staticMethod) {
                    mb.invokestatic(methodClass, method.getName(), methodDesc, interfaceMethod);
                } else if (interfaceMethod) {
                    mb.invokeinterface(methodClass, method.getName(), methodDesc);
                } else {
                    mb.invokevirtual(methodClass, method.getName(), methodDesc);
                }
                if (method.getReturnType() == Void.TYPE) {
                    mb.aconstNull();
                } else {
                    mb.box(method.getReturnType());
                }
                mb.areturn().maxs(method.getParameterCount() + 2, 2);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(method.getDeclaringClass());
        if (staticMethod) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (Function)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (Function)Constructors.invoke(constructor, instance);
    }

    public static <I> I makeDynamicInvoker(@Nonnull Class<I> invokerClass, @Nonnull Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Dynamic invoker can only be used for non-static methods");
        }
        String newClassName = AccessorUtils.makeAccessorName("DynamicMethodInvoker", method.getDeclaringClass(), method.getName());
        Method invokerMethod = MethodAccessor.findInvokerMethod(invokerClass, method, true);
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(invokerClass)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, null, false);
            cb.method(BUILDER.opcode("ACC_PUBLIC"), invokerMethod.getName(), BytecodeUtils.desc(invokerMethod), null, null, mb -> {
                MethodAccessor.pushArgs(mb, invokerMethod.getParameterTypes(), MethodAccessor.prepend(method.getParameterTypes(), method.getDeclaringClass()));
                if (Modifier.isInterface(method.getDeclaringClass().getModifiers())) {
                    mb.invokeinterface(BytecodeUtils.slash(method.getDeclaringClass()), method.getName(), BytecodeUtils.desc(method));
                } else {
                    mb.invokevirtual(BytecodeUtils.slash(method.getDeclaringClass()), method.getName(), BytecodeUtils.desc(method));
                }
                if (!method.getReturnType().equals(invokerMethod.getReturnType())) {
                    mb.checkcast(BytecodeUtils.slash(invokerMethod.getReturnType()));
                }
                mb.return_(invokerMethod.getReturnType());
                mb.maxs(invokerMethod.getParameterCount() + 1, invokerMethod.getParameterCount() + 1);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(method.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (I)Constructors.invoke(constructor, new Object[0]);
    }

    public static <I, R> BiFunction<I, Object[], R> makeDynamicArrayInvoker(@Nonnull Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Dynamic invoker can only be used for non-static methods");
        }
        String newClassName = AccessorUtils.makeAccessorName("DynamicArrayMethodInvoker", method.getDeclaringClass(), method.getName());
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(BiFunction.class)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, null, false);
            cb.method(BUILDER.opcode("ACC_PUBLIC"), "apply", BytecodeUtils.mdesc(Object.class, Object.class, Object.class), null, null, mb -> {
                mb.aload(1).checkcast(BytecodeUtils.slash(method.getDeclaringClass()));
                MethodAccessor.pushArrayArgs(mb, method, 2);
                if (Modifier.isInterface(method.getDeclaringClass().getModifiers())) {
                    mb.invokeinterface(BytecodeUtils.slash(method.getDeclaringClass()), method.getName(), BytecodeUtils.desc(method));
                } else {
                    mb.invokevirtual(BytecodeUtils.slash(method.getDeclaringClass()), method.getName(), BytecodeUtils.desc(method));
                }
                if (method.getReturnType() == Void.TYPE) {
                    mb.aconstNull();
                } else {
                    mb.box(method.getReturnType());
                }
                mb.areturn().maxs(method.getParameterCount() + 2, 3);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(method.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (BiFunction)Constructors.invoke(constructor, new Object[0]);
    }

    private static Method findInvokerMethod(Class<?> invokerClass, Method method, boolean requireInstance) {
        if (!Modifier.isInterface(invokerClass.getModifiers())) {
            throw new IllegalArgumentException("The invoker class must be an interface");
        }
        int abstractMethods = 0;
        Method matched = null;
        for (Method invokerMethod : Methods.getDeclaredMethods(invokerClass)) {
            if (!Modifier.isAbstract(invokerMethod.getModifiers())) continue;
            if (++abstractMethods > 1) {
                throw new IllegalArgumentException("The invoker class must only have one abstract method");
            }
            if (invokerMethod.getParameterCount() != method.getParameterCount() + (requireInstance ? 1 : 0)) {
                throw new IllegalArgumentException("The invoker method must have " + (method.getParameterCount() + (requireInstance ? 1 : 0)) + " parameters");
            }
            if (!invokerMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("The invoker method return type must be of type " + method.getReturnType().getName());
            }
            Class<?>[] invokerParameterTypes = invokerMethod.getParameterTypes();
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            for (int i = 0; i < invokerParameterTypes.length; ++i) {
                Class<?> methodParameterType;
                Class<?> invokerParameterType = invokerParameterTypes[i];
                Class<?> clazz = requireInstance && i == 0 ? method.getDeclaringClass() : (methodParameterType = methodParameterTypes[i - (requireInstance ? 1 : 0)]);
                if (invokerParameterType.isAssignableFrom(methodParameterType)) continue;
                throw new IllegalArgumentException("The invoker method parameter " + i + " must be of type " + methodParameterType);
            }
            matched = invokerMethod;
        }
        if (matched == null) {
            throw new IllegalArgumentException("Could not find a valid invoker method for: " + method);
        }
        return matched;
    }

    private static void pushArgs(MethodBuilder mb, Class<?>[] supplied, Class<?>[] target) {
        int stack = 1;
        for (int i = 0; i < supplied.length; ++i) {
            Class<?> suppliedType = supplied[i];
            Class<?> targetType = target[i];
            mb.load(suppliedType, stack);
            if (!suppliedType.equals(targetType)) {
                mb.checkcast(BytecodeUtils.slash(targetType));
            }
            stack += BytecodeUtils.getStackSize(suppliedType);
        }
    }

    private static void pushArrayArgs(MethodBuilder mb, Method method, int arrayIndex) {
        mb.aload(arrayIndex).checkcast(BytecodeUtils.desc(Object[].class)).astore(arrayIndex);
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Class<?> parameter = method.getParameterTypes()[i];
            mb.aload(arrayIndex).intPush(i).aaload().checkcast(BytecodeUtils.slash(BytecodeUtils.boxed(parameter))).unbox(parameter);
        }
    }

    private static Class<?>[] prepend(Class<?>[] classes, Class<?> other) {
        Class[] newClasses = new Class[classes.length + 1];
        newClasses[0] = other;
        System.arraycopy(classes, 0, newClasses, 1, classes.length);
        return newClasses;
    }
}

