/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.reflect.accessor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.skinsrestorer.shadow.javax.annotation.Nonnull;
import net.skinsrestorer.shadow.reflect.Constructors;
import net.skinsrestorer.shadow.reflect.Methods;
import net.skinsrestorer.shadow.reflect.accessor.AccessorUtils;
import net.skinsrestorer.shadow.reflect.bytecode.BytecodeUtils;
import net.skinsrestorer.shadow.reflect.bytecode.builder.BytecodeBuilder;
import net.skinsrestorer.shadow.reflect.bytecode.wrapper.BuiltClass;

public class FieldAccessor {
    private static final BytecodeBuilder BUILDER = BytecodeBuilder.get();

    public static <I> I makeSetter(@Nonnull Class<?> invokerClass, Object instance, @Nonnull Field field) {
        String newClassName = AccessorUtils.makeAccessorName("FieldSetter", field.getDeclaringClass(), field.getName());
        boolean staticField = Modifier.isStatic(field.getModifiers());
        Method invokerMethod = FieldAccessor.findInvokerMethod(invokerClass, new Class[]{field.getType()}, Void.TYPE);
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(invokerClass)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, () -> instance.getClass(), Modifier.isStatic(field.getModifiers()));
            cb.method(BUILDER.opcode("ACC_PUBLIC"), invokerMethod.getName(), BytecodeUtils.desc(invokerMethod), null, null, mb -> {
                if (staticField) {
                    mb.load(invokerMethod.getParameterTypes()[0], 1);
                    if (!invokerMethod.getParameterTypes()[0].equals(field.getType())) {
                        mb.checkcast(BytecodeUtils.slash(field.getType()));
                    }
                    mb.putstatic(BytecodeUtils.slash(field.getDeclaringClass()), field.getName(), BytecodeUtils.desc(field.getType()));
                } else {
                    mb.aload(0);
                    mb.getfield(newClassName, "instance", BytecodeUtils.desc(instance.getClass()));
                    mb.load(invokerMethod.getParameterTypes()[0], 1);
                    if (!invokerMethod.getParameterTypes()[0].equals(field.getType())) {
                        mb.checkcast(BytecodeUtils.slash(field.getType()));
                    }
                    mb.putfield(BytecodeUtils.slash(field.getDeclaringClass()), field.getName(), BytecodeUtils.desc(field.getType()));
                }
                mb.return_();
                mb.maxs(2, 2);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(field.getDeclaringClass());
        if (staticField) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (I)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (I)Constructors.invoke(constructor, instance);
    }

    public static <I> I makeDynamicSetter(@Nonnull Class<I> invokerClass, @Nonnull Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Dynamic setter can only be used for non-static fields");
        }
        String newClassName = AccessorUtils.makeAccessorName("DynamicFieldSetter", field.getDeclaringClass(), field.getName());
        Method invokerMethod = FieldAccessor.findInvokerMethod(invokerClass, new Class[]{field.getDeclaringClass(), field.getType()}, Void.TYPE);
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(invokerClass)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, null, Modifier.isStatic(field.getModifiers()));
            cb.method(BUILDER.opcode("ACC_PUBLIC"), invokerMethod.getName(), BytecodeUtils.desc(invokerMethod), null, null, mb -> {
                mb.aload(1);
                if (!invokerMethod.getParameterTypes()[0].equals(field.getDeclaringClass())) {
                    mb.checkcast(BytecodeUtils.slash(field.getDeclaringClass()));
                }
                mb.load(invokerMethod.getParameterTypes()[1], 2);
                if (!invokerMethod.getParameterTypes()[1].equals(field.getType())) {
                    mb.checkcast(BytecodeUtils.slash(field.getType()));
                }
                mb.putfield(BytecodeUtils.slash(field.getDeclaringClass()), field.getName(), BytecodeUtils.desc(field.getType()));
                mb.return_();
                mb.maxs(2, 3);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(field.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (I)Constructors.invoke(constructor, new Object[0]);
    }

    public static <I> I makeGetter(@Nonnull Class<I> invokerClass, Object instance, @Nonnull Field field) {
        String newClassName = AccessorUtils.makeAccessorName("FieldGetter", field.getDeclaringClass(), field.getName());
        boolean staticField = Modifier.isStatic(field.getModifiers());
        Method invokerMethod = FieldAccessor.findInvokerMethod(invokerClass, new Class[0], field.getType());
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(invokerClass)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, () -> instance.getClass(), Modifier.isStatic(field.getModifiers()));
            cb.method(BUILDER.opcode("ACC_PUBLIC"), invokerMethod.getName(), BytecodeUtils.desc(invokerMethod), null, null, mb -> {
                if (staticField) {
                    mb.getstatic(BytecodeUtils.slash(field.getDeclaringClass()), field.getName(), BytecodeUtils.desc(field.getType()));
                } else {
                    mb.aload(0);
                    mb.getfield(newClassName, "instance", BytecodeUtils.desc(instance.getClass()));
                    mb.getfield(BytecodeUtils.slash(field.getDeclaringClass()), field.getName(), BytecodeUtils.desc(field.getType()));
                }
                if (!field.getType().equals(invokerMethod.getReturnType())) {
                    mb.checkcast(BytecodeUtils.slash(invokerMethod.getReturnType()));
                }
                mb.return_(invokerMethod.getReturnType());
                mb.maxs(1, 1);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(field.getDeclaringClass());
        if (staticField) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (I)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (I)Constructors.invoke(constructor, instance);
    }

    public static <I> I makeDynamicGetter(@Nonnull Class<I> invokerClass, @Nonnull Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Dynamic setter can only be used for non-static fields");
        }
        String newClassName = AccessorUtils.makeAccessorName("DynamicFieldGetter", field.getDeclaringClass(), field.getName());
        Method invokerMethod = FieldAccessor.findInvokerMethod(invokerClass, new Class[]{field.getDeclaringClass()}, field.getType());
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, "java/lang/Object", new String[]{BytecodeUtils.slash(invokerClass)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, null, Modifier.isStatic(field.getModifiers()));
            cb.method(BUILDER.opcode("ACC_PUBLIC"), invokerMethod.getName(), BytecodeUtils.desc(invokerMethod), null, null, mb -> {
                mb.aload(1);
                if (!invokerMethod.getParameterTypes()[0].equals(field.getDeclaringClass())) {
                    mb.checkcast(BytecodeUtils.slash(field.getDeclaringClass()));
                }
                mb.getfield(BytecodeUtils.slash(field.getDeclaringClass()), field.getName(), BytecodeUtils.desc(field.getType()));
                if (!invokerMethod.getReturnType().equals(field.getType())) {
                    mb.checkcast(BytecodeUtils.slash(invokerMethod.getReturnType()));
                }
                mb.return_(invokerMethod.getReturnType());
                mb.maxs(1, 2);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(field.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (I)Constructors.invoke(constructor, new Object[0]);
    }

    private static Method findInvokerMethod(Class<?> invokerClass, Class<?>[] parameterTypes, Class<?> returnType) {
        if (!Modifier.isInterface(invokerClass.getModifiers())) {
            throw new IllegalArgumentException("The invoker class must be an interface");
        }
        int abstractMethods = 0;
        Method matched = null;
        for (Method invokerMethod : Methods.getDeclaredMethods(invokerClass)) {
            if (!Modifier.isAbstract(invokerMethod.getModifiers())) continue;
            if (++abstractMethods > 1) {
                throw new IllegalArgumentException("The invoker class must only have one abstract method");
            }
            if (invokerMethod.getParameterCount() != parameterTypes.length) {
                throw new IllegalArgumentException("The invoker method must have " + parameterTypes.length + " parameters");
            }
            if (!invokerMethod.getReturnType().isAssignableFrom(returnType)) {
                throw new IllegalArgumentException("The invoker method return type must be of type " + returnType.getName());
            }
            Class<?>[] invokerParameterTypes = invokerMethod.getParameterTypes();
            for (int i = 0; i < invokerParameterTypes.length; ++i) {
                if (invokerParameterTypes[i].isAssignableFrom(parameterTypes[i])) continue;
                throw new IllegalArgumentException("The invoker method parameter " + i + " must be of type " + parameterTypes[i].getName());
            }
            matched = invokerMethod;
        }
        if (matched == null) {
            throw new IllegalArgumentException("Could not find a valid invoker method for: " + BytecodeUtils.mdesc(returnType, parameterTypes));
        }
        return matched;
    }
}

