/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.multilib.regionized.bukkit;

import java.util.function.Consumer;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.multilib.regionized.EntityScheduler;
import net.skinsrestorer.shadow.multilib.regionized.RegionizedTask;
import net.skinsrestorer.shadow.multilib.regionized.bukkit.BukkitRegionizedTaskWrapper;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class BukkitEntitySchedulerImpl
implements EntityScheduler {
    private final Entity entity;

    public BukkitEntitySchedulerImpl(Entity entity) {
        this.entity = entity;
    }

    private Entity getEntity() {
        return this.entity;
    }

    private void handle(RegionizedTask regionizedTask, Consumer<RegionizedTask> runnable, Runnable retired) {
        if (this.getEntity() == null || this.getEntity().isDead() || !this.getEntity().isValid()) {
            regionizedTask.cancel();
            if (retired != null) {
                retired.run();
            }
            return;
        }
        runnable.accept(regionizedTask);
    }

    @Override
    public boolean execute(@NotNull Plugin plugin, @NotNull Runnable run, @Nullable Runnable retired, long delay) {
        new BukkitRegionizedTaskWrapper(plugin, regionizedTask -> this.handle((RegionizedTask)regionizedTask, t -> run.run(), retired), delay).schedule();
        return true;
    }

    @Override
    @Nullable
    public RegionizedTask run(@NotNull Plugin plugin, @NotNull Consumer<RegionizedTask> task, @Nullable Runnable retired) {
        return new BukkitRegionizedTaskWrapper(plugin, regionizedTask -> this.handle((RegionizedTask)regionizedTask, task, retired)).schedule();
    }

    @Override
    @Nullable
    public RegionizedTask runDelayed(@NotNull Plugin plugin, @NotNull Consumer<RegionizedTask> task, @Nullable Runnable retired, long delayTicks) {
        return new BukkitRegionizedTaskWrapper(plugin, regionizedTask -> this.handle((RegionizedTask)regionizedTask, task, retired), delayTicks).schedule();
    }

    @Override
    @Nullable
    public RegionizedTask runAtFixedRate(@NotNull Plugin plugin, @NotNull Consumer<RegionizedTask> task, @Nullable Runnable retired, long initialDelayTicks, long periodTicks) {
        return new BukkitRegionizedTaskWrapper(plugin, regionizedTask -> this.handle((RegionizedTask)regionizedTask, task, retired), initialDelayTicks, periodTicks).schedule();
    }
}

