/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.multilib.bukkit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.shadow.multilib.DataStorageImpl;
import net.skinsrestorer.shadow.multilib.MultiLibImpl;
import net.skinsrestorer.shadow.multilib.bukkit.BukkitImpl;
import net.skinsrestorer.shadow.multilib.util.StringAddition;
import net.skinsrestorer.shadow.snakeyaml.DumperOptions;
import net.skinsrestorer.shadow.snakeyaml.LoaderOptions;
import net.skinsrestorer.shadow.snakeyaml.Yaml;
import net.skinsrestorer.shadow.snakeyaml.constructor.SafeConstructor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitDataStorageImpl
implements DataStorageImpl {
    private final BukkitImpl multilib;
    private CompletableFuture<Map<String, Object>> yaml;
    private CompletableFuture<Void> saveFuture;

    public BukkitDataStorageImpl(BukkitImpl multilib) {
        this.multilib = multilib;
    }

    private synchronized void scheduleSave() {
        if (this.saveFuture == null || this.saveFuture.isDone()) {
            this.saveFuture = CompletableFuture.runAsync(this::saveYaml, CompletableFuture.delayedExecutor(15L, TimeUnit.SECONDS));
        }
    }

    private File getFile() {
        return new File((this.getClass().getPackageName() + ".").replace("\tcom.github.puregero.multilib.bukkit.".substring(1), "") + "datastorage.yml");
    }

    private synchronized void saveYaml() {
        File file = this.getFile();
        try (FileWriter out = new FileWriter(file);){
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            new Yaml(options).dump(this.yaml.join(), out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized CompletableFuture<Map<String, Object>> loadYaml() {
        if (this.yaml == null) {
            this.yaml = CompletableFuture.supplyAsync(() -> {
                this.registerShutdownHook();
                File file = this.getFile();
                if (file.isFile()) {
                    Map map;
                    FileInputStream in = new FileInputStream(file);
                    try {
                        map = (Map)new Yaml(new SafeConstructor(new LoaderOptions())).load(in);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    in.close();
                    return map;
                }
                return new HashMap();
            });
        }
        return this.yaml;
    }

    private void registerShutdownHook() {
        final JavaPlugin plugin = JavaPlugin.getProvidingPlugin(this.getClass());
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onDisable(PluginDisableEvent event) {
                if (event.getPlugin() == plugin && BukkitDataStorageImpl.this.saveFuture != null && !BukkitDataStorageImpl.this.saveFuture.isDone()) {
                    System.out.println("Saving unsaved datastorage.yaml...");
                    BukkitDataStorageImpl.this.saveYaml();
                }
            }
        }, (Plugin)plugin);
    }

    @Override
    public CompletableFuture<String> get(String key) {
        return this.loadYaml().thenApply(yaml -> (String)yaml.get(key));
    }

    @Override
    public CompletableFuture<Map<String, String>> list(String keyPrefix) {
        return this.loadYaml().thenApply(yaml -> {
            HashMap<String, String> list = new HashMap<String, String>();
            for (Map.Entry entry : yaml.entrySet()) {
                if (entry.getKey() == null || !((String)entry.getKey()).startsWith(keyPrefix) || !(entry.getValue() instanceof String)) continue;
                list.put((String)entry.getKey(), (String)entry.getValue());
            }
            return list;
        });
    }

    @Override
    public CompletableFuture<String> set(String key, String value) {
        return this.loadYaml().thenApply(yaml -> {
            if (value == null) {
                yaml.remove(key);
            } else {
                yaml.put(key, value);
            }
            this.scheduleSave();
            return value;
        });
    }

    @Override
    public CompletableFuture<String> add(String key, String increment) {
        return this.loadYaml().thenApply(yaml -> {
            String result = StringAddition.add((String)yaml.get(key), increment);
            yaml.put(key, result);
            this.scheduleSave();
            return result;
        });
    }

    @Override
    public MultiLibImpl getMultiLib() {
        return this.multilib;
    }
}

