/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.authentication.addon;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.HostAddress;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Reader;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.export.SslMode;
import net.skinsrestorer.shadow.mariadb.plugin.AuthenticationPlugin;

public class ClearPasswordPlugin
implements AuthenticationPlugin {
    private final String authenticationData;
    private final HostAddress hostAddress;
    private final Configuration conf;

    public ClearPasswordPlugin(String authenticationData, HostAddress hostAddress, Configuration conf) {
        this.authenticationData = authenticationData;
        this.hostAddress = hostAddress;
        this.conf = conf;
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context, boolean sslFingerPrintValidation) throws IOException, SQLException {
        SslMode sslMode;
        SslMode sslMode2 = sslMode = this.hostAddress.sslMode == null ? this.conf.sslMode() : this.hostAddress.sslMode;
        if (sslMode != SslMode.DISABLE && sslMode != SslMode.TRUST && sslFingerPrintValidation) {
            throw new SQLException("Driver cannot send password in clear when using SSL when certificates are not explicitly passed on configuration.", "S1010");
        }
        if (this.authenticationData == null) {
            out.writeEmptyPacket();
        } else {
            byte[] bytePwd = this.authenticationData.getBytes(StandardCharsets.UTF_8);
            out.writeBytes(bytePwd);
            out.writeByte(0);
            out.flush();
        }
        return in.readReusablePacket();
    }
}

