/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.socket.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.HostAddress;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.impl.StandardReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Reader;
import net.skinsrestorer.shadow.mariadb.client.util.MutableByte;
import net.skinsrestorer.shadow.mariadb.util.log.Logger;
import net.skinsrestorer.shadow.mariadb.util.log.LoggerHelper;
import net.skinsrestorer.shadow.mariadb.util.log.Loggers;

public class PacketReader
implements Reader {
    private static final int REUSABLE_BUFFER_LENGTH = 8192;
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private static final Logger logger = Loggers.getLogger(PacketReader.class);
    private final byte[] header = new byte[4];
    private final byte[] reusableArray = new byte[8192];
    private final InputStream inputStream;
    private final int maxQuerySizeToLog;
    private final MutableByte sequence;
    private final StandardReadableByteBuf readBuf = new StandardReadableByteBuf(null, 0);
    private String serverThreadLog = "";

    public PacketReader(InputStream in, Configuration conf, MutableByte sequence) {
        this.inputStream = in;
        this.maxQuerySizeToLog = conf.maxQuerySizeToLog();
        this.sequence = sequence;
    }

    @Override
    public ReadableByteBuf readableBufFromArray(byte[] buf) {
        this.readBuf.buf(buf, buf.length, 0);
        return this.readBuf;
    }

    @Override
    public ReadableByteBuf readReusablePacket() throws IOException {
        return this.readReusablePacket(logger.isTraceEnabled());
    }

    @Override
    public ReadableByteBuf readReusablePacket(boolean traceEnable) throws IOException {
        int count;
        int lastPacketLength = this.readHeader();
        this.sequence.set(this.header[3]);
        byte[] rawBytes = lastPacketLength < 8192 ? this.reusableArray : new byte[lastPacketLength];
        int remaining = lastPacketLength;
        int off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (lastPacketLength - remaining) + " bytes from " + lastPacketLength + " (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
        if (traceEnable) {
            logger.trace("read: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.header, rawBytes, 0, lastPacketLength, this.maxQuerySizeToLog));
        }
        this.readBuf.buf(rawBytes, lastPacketLength, 0);
        return this.readBuf;
    }

    @Override
    public byte[] readPacket(boolean traceEnable) throws IOException {
        int count;
        int packetLength = this.readHeader();
        byte[] rawBytes = new byte[packetLength];
        int remaining = packetLength;
        int off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (packetLength - remaining) + " bytes from " + packetLength + " (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
        if (traceEnable) {
            logger.trace("read: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.header, rawBytes, 0, packetLength, this.maxQuerySizeToLog));
        }
        if (packetLength == 0xFFFFFF) {
            do {
                int count2;
                packetLength = this.readHeader();
                int currentLength = rawBytes.length;
                byte[] newRawBytes = new byte[currentLength + packetLength];
                System.arraycopy(rawBytes, 0, newRawBytes, 0, currentLength);
                rawBytes = newRawBytes;
                remaining = packetLength;
                off = currentLength;
                do {
                    if ((count2 = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + (packetLength - remaining) + " bytes from " + packetLength);
                    }
                    off += count2;
                } while ((remaining -= count2) > 0);
                if (!traceEnable) continue;
                logger.trace("read: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.header, rawBytes, currentLength, packetLength, this.maxQuerySizeToLog));
            } while (packetLength == 0xFFFFFF);
        }
        return rawBytes;
    }

    @Override
    public MutableByte getSequence() {
        return this.sequence;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void setServerThreadId(Long serverThreadId, HostAddress hostAddress) {
        Boolean isMaster = hostAddress != null ? hostAddress.primary : null;
        this.serverThreadLog = "conn=" + (serverThreadId == null ? "-1" : serverThreadId) + (isMaster != null ? " (" + (isMaster != false ? "M" : "S") + ")" : "");
    }

    private int readHeader() throws IOException {
        int count;
        int remaining = 4;
        int off = 0;
        do {
            if ((count = this.inputStream.read(this.header, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4 (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
        return (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
    }
}

