/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;
import net.skinsrestorer.shadow.mariadb.message.server.ColumnDefinitionPacket;
import net.skinsrestorer.shadow.mariadb.plugin.codec.LocalDateTimeCodec;

public class TimestampColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DecimalFormat oldDecimalFormat = new DecimalFormat(".0#####", DecimalFormatSymbols.getInstance(Locale.US));
    private static final int[] POWERS_OF_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};

    public TimestampColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected TimestampColumn(TimestampColumn prev) {
        super(prev, true);
    }

    @Override
    public TimestampColumn useAliasAsName() {
        return new TimestampColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Timestamp.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 93;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return this.dataType.name();
    }

    @Override
    public Object getDefaultText(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        return this.decodeTimestampText(buf, length, null, context);
    }

    @Override
    public Object getDefaultBinary(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        return this.decodeTimestampBinary(buf, length, null, context);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar providedCal, Context context) throws SQLDataException {
        if (length.get() == 0) {
            return this.buildZeroDate();
        }
        int initialPos = buf.pos();
        int initialLength = length.get();
        try {
            LocalDateTime ldt = this.parseText(buf, length);
            if (ldt == null) {
                if (initialLength > 0) {
                    return this.buildZeroDate();
                }
                return null;
            }
            LocalDateTime modifiedLdt = TimestampColumn.localDateTimeToZoneDateTime(ldt, providedCal, context).toLocalDateTime();
            String timestampWithoutMicro = dateTimeFormatter.format(modifiedLdt);
            if (context.getConf().oldModeNoPrecisionTimestamp()) {
                return timestampWithoutMicro + oldDecimalFormat.format((double)modifiedLdt.getNano() / 1.0E9);
            }
            if (this.decimals == 0) {
                return timestampWithoutMicro;
            }
            return timestampWithoutMicro + "." + String.format(Locale.US, "%0" + this.decimals + "d", modifiedLdt.getNano() / 1000);
        }
        catch (DateTimeException e) {
            buf.pos(initialPos);
            return buf.readString(length.get());
        }
    }

    private String buildZeroDate() {
        StringBuilder zeroValue = new StringBuilder("0000-00-00 00:00:00");
        if (this.decimals > 0) {
            zeroValue.append(".");
            for (int i = 0; i < this.decimals; ++i) {
                zeroValue.append("0");
            }
        }
        return zeroValue.toString();
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar providedCal, Context context) throws SQLDataException {
        if (length.get() == 0) {
            return this.buildZeroDate();
        }
        int initialPos = buf.pos();
        int initialLength = length.get();
        try {
            LocalDateTime ldt = this.parseBinary(buf, length);
            if (ldt == null) {
                if (initialLength > 0) {
                    return this.buildZeroDate();
                }
                return null;
            }
            LocalDateTime modifiedLdt = TimestampColumn.localDateTimeToZoneDateTime(ldt, providedCal, context).toLocalDateTime();
            String timestampWithoutMicro = dateTimeFormatter.format(modifiedLdt);
            if (context.getConf().oldModeNoPrecisionTimestamp()) {
                return timestampWithoutMicro + oldDecimalFormat.format((double)modifiedLdt.getNano() / 1.0E9);
            }
            if (this.decimals == 0) {
                return timestampWithoutMicro;
            }
            return timestampWithoutMicro + "." + String.format(Locale.US, "%0" + this.decimals + "d", modifiedLdt.getNano() / 1000);
        }
        catch (DateTimeException e) {
            buf.pos(initialPos);
            int year = buf.readUnsignedShort();
            byte month = buf.readByte();
            byte dayOfMonth = buf.readByte();
            byte hour = 0;
            byte minutes = 0;
            byte seconds = 0;
            long microseconds = 0L;
            if (length.get() > 4) {
                hour = buf.readByte();
                minutes = buf.readByte();
                seconds = buf.readByte();
                if (length.get() > 7) {
                    microseconds = buf.readUnsignedInt();
                }
            }
            StringBuilder sb = new StringBuilder();
            this.fill(year, 4, sb);
            sb.append("-");
            this.fill(month, 2, sb);
            sb.append("-");
            this.fill(dayOfMonth, 2, sb);
            sb.append(" ");
            this.fill(hour, 2, sb);
            sb.append(":");
            this.fill(minutes, 2, sb);
            sb.append(":");
            this.fill(seconds, 2, sb);
            if (this.getDecimals() == 0) {
                return sb.toString();
            }
            sb.append(".");
            this.fill((int)(microseconds / (long)POWERS_OF_10[6 - this.getDecimals()]), this.getDecimals(), sb);
            return sb.toString();
        }
    }

    private void fill(int val, int size, StringBuilder sb) {
        String valSt = String.valueOf(val);
        int zeroToAdd = size - valSt.length();
        for (int i = 0; i < zeroToAdd; ++i) {
            sb.append('0');
        }
        sb.append(valSt);
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Date(TimestampColumn.localDateTimeToInstant(ldt, calParam, context) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Date(TimestampColumn.localDateTimeToInstant(ldt, calParam, context) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Time(TimestampColumn.localDateTimeToInstant(ldt.withYear(1970).withMonth(1).withDayOfMonth(1), calParam, context) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Time(TimestampColumn.localDateTimeToInstant(ldt.withYear(1970).withMonth(1).withDayOfMonth(1), calParam, context) + (long)(ldt.getNano() / 1000000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        int[] parts = LocalDateTimeCodec.parseTextTimestamp(buf, length);
        if (LocalDateTimeCodec.isZeroTimestamp(parts)) {
            length.set(-1);
            return null;
        }
        try {
            LocalDateTime ldt = LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]);
            Timestamp res = new Timestamp(TimestampColumn.localDateTimeToInstant(ldt, calParam, context));
            res.setNanos(ldt.getNano());
            return res;
        }
        catch (DateTimeException e) {
            Timestamp timestamp;
            Calendar cal;
            Calendar calendar = cal = calParam == null ? Calendar.getInstance() : calParam;
            synchronized (calendar) {
                cal.setLenient(true);
                cal.clear();
                cal.set(1, parts[0]);
                cal.set(2, parts[1] - 1);
                cal.set(5, parts[2]);
                cal.set(11, parts[3]);
                cal.set(12, parts[4]);
                cal.set(13, parts[5]);
                cal.set(14, parts[6] / 1000000);
                timestamp = new Timestamp(cal.getTime().getTime());
            }
            timestamp.setNanos(parts[6]);
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        if (length.get() == 0) {
            length.set(-1);
            return null;
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        int seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        try {
            LocalDateTime ldt = LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minutes, seconds).plusNanos(microseconds * 1000L);
            if (ldt == null) {
                return null;
            }
            Timestamp res = new Timestamp(TimestampColumn.localDateTimeToInstant(ldt, calParam, context));
            res.setNanos(ldt.getNano());
            return res;
        }
        catch (DateTimeException e) {
            Timestamp timestamp;
            Calendar cal;
            Calendar calendar = cal = calParam == null ? Calendar.getInstance() : calParam;
            synchronized (calendar) {
                cal.setLenient(true);
                cal.clear();
                cal.set(1, year);
                cal.set(2, month - 1);
                cal.set(5, dayOfMonth);
                cal.set(11, hour);
                cal.set(12, minutes);
                cal.set(13, seconds);
                cal.set(14, (int)(microseconds / 1000000L));
                timestamp = new Timestamp(cal.getTime().getTime());
            }
            timestamp.setNanos((int)(microseconds * 1000L));
            return timestamp;
        }
    }

    private LocalDateTime parseText(ReadableByteBuf buf, MutableInt length) {
        int[] parts = LocalDateTimeCodec.parseTextTimestamp(buf, length);
        if (LocalDateTimeCodec.isZeroTimestamp(parts)) {
            length.set(-1);
            return null;
        }
        return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]);
    }

    private LocalDateTime parseBinary(ReadableByteBuf buf, MutableInt length) {
        if (length.get() == 0) {
            length.set(-1);
            return null;
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        int seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minutes, seconds).plusNanos(microseconds * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long localDateTimeToInstant(LocalDateTime ldt, Calendar calParam, Context context) {
        if (calParam == null) {
            Calendar cal = context.getDefaultCalendar();
            cal.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
            cal.set(14, 0);
            return cal.getTimeInMillis();
        }
        Calendar calendar = calParam;
        synchronized (calendar) {
            calParam.clear();
            calParam.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
            return calParam.getTimeInMillis();
        }
    }

    public static ZonedDateTime localDateTimeToZoneDateTime(LocalDateTime ldt, Calendar calParam, Context context) {
        if (calParam == null) {
            if (context.getConf().preserveInstants()) {
                return ldt.atZone(context.getConnectionTimeZone().toZoneId()).withZoneSameInstant(TimeZone.getDefault().toZoneId());
            }
            return ldt.atZone(TimeZone.getDefault().toZoneId());
        }
        return ldt.atZone(calParam.getTimeZone().toZoneId());
    }
}

