/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.kyori.adventure.text.minimessage.translation;

import java.util.List;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.Context;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.ParsingException;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.Tag;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

final class ArgumentTag
implements TagResolver {
    private static final String NAME = "argument";
    private static final String NAME_1 = "arg";
    private final List<Tag> arguments;
    private final TagResolver tagResolver;

    ArgumentTag(@NotNull List<Tag> arguments, @NotNull TagResolver tagResolver) {
        this.arguments = arguments;
        this.tagResolver = tagResolver;
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
        if (name.equals(NAME) || name.equals(NAME_1)) {
            int index = arguments.popOr("No argument number provided").asInt().orElseThrow(() -> ctx.newException("Invalid argument number", arguments));
            if (index < 0 || index >= this.arguments.size()) {
                throw ctx.newException("Invalid argument number", arguments);
            }
            return this.arguments.get(index);
        }
        return this.tagResolver.resolve(name, arguments, ctx);
    }

    @Override
    public boolean has(@NotNull String name) {
        return name.equals(NAME) || name.equals(NAME_1) || this.tagResolver.has(name);
    }
}

