/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector.handlers.dependency;

import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.injector.context.ResolutionContext;
import net.skinsrestorer.shadow.injector.exceptions.InjectorException;
import net.skinsrestorer.shadow.injector.factory.Factory;
import net.skinsrestorer.shadow.injector.handlers.Handler;
import net.skinsrestorer.shadow.injector.handlers.instantiation.Resolution;
import net.skinsrestorer.shadow.injector.handlers.instantiation.SimpleResolution;
import net.skinsrestorer.shadow.injector.utils.ReflectionUtils;

public class FactoryDependencyHandler
implements Handler {
    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        Class<?> clazz = context.getIdentifier().getTypeAsClass();
        if (Factory.class.equals(clazz)) {
            Class<?> genericType = ReflectionUtils.getGenericType(context.getIdentifier().getType());
            if (genericType == null) {
                throw new InjectorException("Factory fields must have concrete generic type. Cannot get generic type for field in '" + context.getIdentifier().getTypeAsClass() + "'");
            }
            return new SimpleResolution(new FactoryImpl(genericType, context.getInjector()));
        }
        return null;
    }

    private static final class FactoryImpl<P>
    implements Factory<P> {
        private final Injector injector;
        private final Class<P> parentClass;

        FactoryImpl(Class<P> parentClass, Injector injector) {
            this.parentClass = parentClass;
            this.injector = injector;
        }

        @Override
        public <C extends P> C newInstance(Class<C> clazz) {
            if (this.parentClass.isAssignableFrom(clazz)) {
                return this.injector.newInstance(clazz);
            }
            throw new InjectorException(clazz + " not child of " + this.parentClass);
        }
    }
}

