/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationDataBuilder;
import net.skinsrestorer.shadow.configme.migration.MigrationService;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.configme.resource.PropertyResource;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class SettingsHolderClassValidator {
    @SafeVarargs
    public final void validate(Class<? extends SettingsHolder> ... settingHolders) {
        this.validate(Arrays.asList(settingHolders));
    }

    public void validate(@NotNull Iterable<Class<? extends SettingsHolder>> settingHolders) {
        this.validateAllPropertiesAreConstants(settingHolders);
        this.validateSettingsHolderClassesFinal(settingHolders);
        this.validateClassesHaveHiddenNoArgConstructor(settingHolders);
        ConfigurationData configurationData = this.createConfigurationData(settingHolders);
        this.validateHasCommentOnEveryProperty(configurationData, null);
        this.validateCommentLengthsAreWithinBounds(configurationData, null, 90);
        this.validateHasAllEnumEntriesInComment(configurationData, null);
    }

    public void validateConfigurationDataValidForMigrationService(@NotNull ConfigurationData configurationData, @NotNull PropertyResource resource, @NotNull MigrationService migrationService) {
        resource.exportProperties(configurationData);
        PropertyReader reader = resource.createReader();
        if (migrationService.checkAndMigrate(reader, configurationData)) {
            throw new IllegalStateException("Migration service unexpectedly returned that a migration is required");
        }
    }

    public void validateAllPropertiesAreConstants(@NotNull Iterable<Class<? extends SettingsHolder>> settingHolders) {
        ArrayList invalidFields = new ArrayList();
        for (Class<? extends SettingsHolder> clazz : settingHolders) {
            List invalidFieldsForClazz = this.getAllFields(clazz).filter(field -> Property.class.isAssignableFrom(field.getType())).filter(field -> !this.isValidConstantField((Field)field)).map(field -> field.getDeclaringClass().getSimpleName() + "#" + field.getName()).collect(Collectors.toList());
            invalidFields.addAll(invalidFieldsForClazz);
        }
        if (!invalidFields.isEmpty()) {
            throw new IllegalStateException("The following fields were found not to be public static final:\n- " + String.join((CharSequence)"\n- ", invalidFields));
        }
    }

    public void validateSettingsHolderClassesFinal(@NotNull Iterable<Class<? extends SettingsHolder>> settingHolders) {
        ArrayList<String> invalidClasses = new ArrayList<String>();
        for (Class<? extends SettingsHolder> clazz : settingHolders) {
            if (Modifier.isFinal(clazz.getModifiers())) continue;
            invalidClasses.add(clazz.getCanonicalName());
        }
        if (!invalidClasses.isEmpty()) {
            throw new IllegalStateException("The following classes are not final:\n- " + String.join((CharSequence)"\n- ", invalidClasses));
        }
    }

    public void validateClassesHaveHiddenNoArgConstructor(@NotNull Iterable<Class<? extends SettingsHolder>> settingHolders) {
        ArrayList<String> invalidClasses = new ArrayList<String>();
        for (Class<? extends SettingsHolder> clazz : settingHolders) {
            if (this.hasValidConstructorSetup(clazz)) continue;
            invalidClasses.add(clazz.getCanonicalName());
        }
        if (!invalidClasses.isEmpty()) {
            throw new IllegalStateException("The following classes do not have a single no-args private constructor:\n- " + String.join((CharSequence)"\n- ", invalidClasses));
        }
    }

    public void validateHasCommentOnEveryProperty(@NotNull ConfigurationData configurationData, @Nullable Predicate<Property<?>> propertyFilter) {
        Predicate<Property> filter = propertyFilter == null ? p -> true : propertyFilter;
        ArrayList<String> invalidProperties = new ArrayList<String>();
        Map<String, List<String>> comments = configurationData.getAllComments();
        for (Property<?> property : configurationData.getProperties()) {
            List<String> commentEntry;
            if (!filter.test(property) || this.hasNonEmptyComment(commentEntry = comments.get(property.getPath()))) continue;
            invalidProperties.add(property.toString());
        }
        if (!invalidProperties.isEmpty()) {
            throw new IllegalStateException("The following properties do not have a comment:\n- " + String.join((CharSequence)"\n- ", invalidProperties));
        }
    }

    public void validateCommentLengthsAreWithinBounds(@NotNull ConfigurationData configurationData, @Nullable Integer minLength, @Nullable Integer maxLength) {
        Predicate<String> hasInvalidLengthPredicate = this.createValidLengthPredicate(minLength, maxLength).negate();
        ArrayList<String> invalidPaths = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : configurationData.getAllComments().entrySet()) {
            boolean hasInvalidLength = entry.getValue().stream().anyMatch(hasInvalidLengthPredicate);
            if (!hasInvalidLength) continue;
            invalidPaths.add("Path '" + entry.getKey() + "'");
        }
        if (!invalidPaths.isEmpty()) {
            String bound;
            String string = bound = minLength == null ? "" : "min length of " + minLength;
            if (maxLength != null) {
                bound = bound + (bound.isEmpty() ? "" : ", ") + "max length of " + maxLength;
            }
            throw new IllegalStateException("The comments for the following paths are not within the bounds: " + bound + " characters:\n- " + String.join((CharSequence)"\n- ", invalidPaths));
        }
    }

    public void validateHasAllEnumEntriesInComment(@NotNull ConfigurationData configurationData, @Nullable Predicate<Property<?>> propertyFilter) {
        ArrayList<String> commentErrors = new ArrayList<String>();
        for (Property<?> property : configurationData.getProperties()) {
            Class<? extends Enum<?>> enumType;
            if (propertyFilter != null && !propertyFilter.test(property) || (enumType = this.getEnumTypeOfProperty(property)) == null) continue;
            List<String> expectedEnums = this.gatherExpectedEnumNames(enumType);
            String comments = String.join((CharSequence)"\n", configurationData.getCommentsForSection(property.getPath()));
            List missingEnumEntries = expectedEnums.stream().filter(e -> !comments.contains((CharSequence)e)).collect(Collectors.toList());
            if (missingEnumEntries.isEmpty()) continue;
            commentErrors.add("For " + property + ": missing " + String.join((CharSequence)", ", missingEnumEntries));
        }
        if (!commentErrors.isEmpty()) {
            throw new IllegalStateException("The following enum properties do not list all enum values:\n- " + String.join((CharSequence)"\n- ", commentErrors));
        }
    }

    protected boolean isValidConstantField(@NotNull Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    @NotNull
    protected ConfigurationData createConfigurationData(@NotNull Iterable<Class<? extends SettingsHolder>> classes) {
        return ConfigurationDataBuilder.createConfiguration(classes);
    }

    protected boolean hasNonEmptyComment(@Nullable List<String> comments) {
        return comments != null && comments.stream().anyMatch(line -> !line.trim().isEmpty());
    }

    @NotNull
    protected Predicate<String> createValidLengthPredicate(@Nullable Integer minLength, @Nullable Integer maxLength) {
        if (minLength == null && maxLength == null) {
            throw new IllegalArgumentException("min length or max length must be not null");
        }
        return string -> !(minLength != null && minLength > string.length() || maxLength != null && maxLength < string.length());
    }

    @Nullable
    protected Class<? extends Enum<?>> getEnumTypeOfProperty(@NotNull Property<?> property) {
        Class<?> defaultValueType = property.getDefaultValue().getClass();
        if (defaultValueType.isAnonymousClass()) {
            defaultValueType = defaultValueType.getEnclosingClass();
        }
        return defaultValueType.isEnum() ? defaultValueType : null;
    }

    @NotNull
    protected List<String> gatherExpectedEnumNames(@NotNull Class<? extends Enum<?>> enumClass) {
        return Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
    }

    protected boolean hasValidConstructorSetup(@NotNull Class<? extends SettingsHolder> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        return constructors.length == 1 && constructors[0].getParameterCount() == 0 && Modifier.isPrivate(constructors[0].getModifiers());
    }

    @NotNull
    protected Stream<Field> getAllFields(@NotNull Class<?> clazz) {
        if (Object.class.equals(clazz.getSuperclass())) {
            return Arrays.stream(clazz.getDeclaredFields());
        }
        ArrayList classes = new ArrayList();
        for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            classes.add(currentClass);
        }
        return classes.stream().flatMap(clz -> Arrays.stream(clz.getDeclaredFields()));
    }
}

