/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.resource;

import java.util.ArrayList;
import java.util.List;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.utils.CollectionUtils;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public class PropertyPathTraverser {
    private final ConfigurationData configurationData;
    private List<String> parentPathElements = new ArrayList<String>(0);
    private boolean isFirstProperty = true;

    public PropertyPathTraverser(@NotNull ConfigurationData configurationData) {
        this.configurationData = configurationData;
    }

    @NotNull
    public List<PathElement> getPathElements(@NotNull List<String> pathElements) {
        List<String> commonPathParts = CollectionUtils.filterCommonStart(this.parentPathElements, pathElements.subList(0, pathElements.size() - 1));
        List<String> newPathParts = CollectionUtils.getRange(pathElements, commonPathParts.size());
        this.parentPathElements = pathElements.subList(0, pathElements.size() - 1);
        int indentationLevel = commonPathParts.size();
        String prefix = commonPathParts.isEmpty() ? "" : String.join((CharSequence)".", commonPathParts) + ".";
        return this.convertToPathElements(indentationLevel, prefix, newPathParts);
    }

    @NotNull
    private List<PathElement> convertToPathElements(int indentation, @NotNull String prefix, @NotNull List<String> elements) {
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>(elements.size());
        for (String element : elements) {
            List<String> comments = this.isFirstProperty ? this.getCommentsIncludingRoot(prefix + element) : this.configurationData.getCommentsForSection(prefix + element);
            pathElements.add(new PathElement(indentation, element, comments, this.isFirstProperty));
            this.isFirstProperty = false;
            prefix = prefix + element + ".";
            ++indentation;
        }
        ((PathElement)pathElements.get(0)).setFirstOfGroup(true);
        return pathElements;
    }

    @NotNull
    private List<String> getCommentsIncludingRoot(@NotNull String path) {
        List<String> rootComments = this.configurationData.getCommentsForSection("");
        if ("".equals(path)) {
            return rootComments;
        }
        List<String> sectionComments = this.configurationData.getCommentsForSection(path);
        if (sectionComments.isEmpty()) {
            return rootComments;
        }
        ArrayList<String> allComments = new ArrayList<String>(rootComments);
        allComments.addAll(sectionComments);
        return allComments;
    }

    public static class PathElement {
        private final int indentationLevel;
        private final String name;
        private final List<String> comments;
        private final boolean isFirstElement;
        private boolean isFirstOfGroup;

        public PathElement(int indentationLevel, @NotNull String name, @NotNull List<String> comments, boolean isFirstElement) {
            this.indentationLevel = indentationLevel;
            this.name = name;
            this.comments = comments;
            this.isFirstElement = isFirstElement;
        }

        public int getIndentationLevel() {
            return this.indentationLevel;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public List<String> getComments() {
            return this.comments;
        }

        public boolean isFirstElement() {
            return this.isFirstElement;
        }

        public boolean isFirstOfGroup() {
            return this.isFirstOfGroup;
        }

        void setFirstOfGroup(boolean firstOfGroup) {
            this.isFirstOfGroup = firstOfGroup;
        }
    }
}

