/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.properties;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import net.skinsrestorer.shadow.configme.properties.BeanProperty;
import net.skinsrestorer.shadow.configme.properties.BooleanProperty;
import net.skinsrestorer.shadow.configme.properties.DoubleProperty;
import net.skinsrestorer.shadow.configme.properties.EnumProperty;
import net.skinsrestorer.shadow.configme.properties.IntegerProperty;
import net.skinsrestorer.shadow.configme.properties.LongProperty;
import net.skinsrestorer.shadow.configme.properties.LowercaseStringSetProperty;
import net.skinsrestorer.shadow.configme.properties.OptionalProperty;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.PropertyBuilder;
import net.skinsrestorer.shadow.configme.properties.RegexProperty;
import net.skinsrestorer.shadow.configme.properties.ShortProperty;
import net.skinsrestorer.shadow.configme.properties.StringListProperty;
import net.skinsrestorer.shadow.configme.properties.StringProperty;
import net.skinsrestorer.shadow.configme.properties.StringSetProperty;
import net.skinsrestorer.shadow.configme.properties.inlinearray.InlineArrayConverter;
import net.skinsrestorer.shadow.configme.properties.types.PropertyType;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public class PropertyInitializer {
    protected PropertyInitializer() {
    }

    @NotNull
    public static Property<Boolean> newProperty(@NotNull String path, boolean defaultValue) {
        return new BooleanProperty(path, defaultValue);
    }

    @NotNull
    public static Property<Short> newProperty(@NotNull String path, short defaultValue) {
        return new ShortProperty(path, defaultValue);
    }

    @NotNull
    public static Property<Integer> newProperty(@NotNull String path, int defaultValue) {
        return new IntegerProperty(path, defaultValue);
    }

    @NotNull
    public static Property<Long> newProperty(@NotNull String path, long defaultValue) {
        return new LongProperty(path, defaultValue);
    }

    @NotNull
    public static Property<Double> newProperty(@NotNull String path, double defaultValue) {
        return new DoubleProperty(path, defaultValue);
    }

    @NotNull
    public static Property<String> newProperty(@NotNull String path, @NotNull String defaultValue) {
        return new StringProperty(path, defaultValue);
    }

    @NotNull
    public static <E extends Enum<E>> Property<E> newProperty(@NotNull Class<E> clazz, @NotNull String path, @NotNull E defaultValue) {
        return new EnumProperty<E>(clazz, path, defaultValue);
    }

    @NotNull
    public static RegexProperty newRegexProperty(@NotNull String path, @NotNull String defaultRegexValue) {
        return new RegexProperty(path, defaultRegexValue);
    }

    @NotNull
    public static RegexProperty newRegexProperty(@NotNull String path, @NotNull Pattern defaultRegexValue) {
        return new RegexProperty(path, defaultRegexValue);
    }

    @NotNull
    public static Property<List<String>> newListProperty(@NotNull String path, String ... defaultValues) {
        return new StringListProperty(path, defaultValues);
    }

    @NotNull
    public static Property<List<String>> newListProperty(@NotNull String path, @NotNull List<String> defaultValues) {
        return new StringListProperty(path, defaultValues);
    }

    @NotNull
    public static Property<Set<String>> newSetProperty(@NotNull String path, String ... defaultValues) {
        return new StringSetProperty(path, defaultValues);
    }

    @NotNull
    public static Property<Set<String>> newSetProperty(@NotNull String path, @NotNull Set<String> defaultValues) {
        return new StringSetProperty(path, defaultValues);
    }

    @NotNull
    public static Property<Set<String>> newLowercaseStringSetProperty(@NotNull String path, String ... defaultValues) {
        return new LowercaseStringSetProperty(path, defaultValues);
    }

    @NotNull
    public static Property<Set<String>> newLowercaseStringSetProperty(@NotNull String path, @NotNull Collection<String> defaultValues) {
        return new LowercaseStringSetProperty(path, defaultValues);
    }

    @NotNull
    public static <B> Property<B> newBeanProperty(@NotNull Class<B> beanClass, @NotNull String path, @NotNull B defaultValue) {
        return new BeanProperty<B>(beanClass, path, defaultValue);
    }

    public static <T> @NotNull PropertyBuilder.TypeBasedPropertyBuilder<T> typeBasedProperty(@NotNull PropertyType<T> type) {
        return new PropertyBuilder.TypeBasedPropertyBuilder<T>(type);
    }

    public static <T> @NotNull PropertyBuilder.ListPropertyBuilder<T> listProperty(@NotNull PropertyType<T> type) {
        return new PropertyBuilder.ListPropertyBuilder<T>(type);
    }

    public static <T> @NotNull PropertyBuilder.SetPropertyBuilder<T> setProperty(@NotNull PropertyType<T> type) {
        return new PropertyBuilder.SetPropertyBuilder<T>(type);
    }

    public static <T> @NotNull PropertyBuilder.MapPropertyBuilder<T> mapProperty(@NotNull PropertyType<T> type) {
        return new PropertyBuilder.MapPropertyBuilder<T>(type);
    }

    public static <T> @NotNull PropertyBuilder.ArrayPropertyBuilder<T> arrayProperty(@NotNull PropertyType<T> type, @NotNull IntFunction<T[]> arrayProducer) {
        return new PropertyBuilder.ArrayPropertyBuilder<T>(type, arrayProducer);
    }

    public static <T> @NotNull PropertyBuilder.InlineArrayPropertyBuilder<T> inlineArrayProperty(@NotNull InlineArrayConverter<T> inlineConverter) {
        return new PropertyBuilder.InlineArrayPropertyBuilder<T>(inlineConverter);
    }

    @NotNull
    public static Property<Optional<Boolean>> optionalBooleanProperty(@NotNull String path) {
        return new OptionalProperty<Boolean>(new BooleanProperty(path, false));
    }

    @NotNull
    public static Property<Optional<Integer>> optionalIntegerProperty(@NotNull String path) {
        return new OptionalProperty<Integer>(new IntegerProperty(path, 0));
    }

    @NotNull
    public static Property<Optional<String>> optionalStringProperty(@NotNull String path) {
        return new OptionalProperty<String>(new StringProperty(path, ""));
    }

    @NotNull
    public static <E extends Enum<E>> Property<Optional<E>> optionalEnumProperty(@NotNull Class<E> clazz, @NotNull String path) {
        return new OptionalProperty<Enum>(new EnumProperty<Enum>(clazz, path, ((Enum[])clazz.getEnumConstants())[0]));
    }
}

