/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.velocity;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.util.Types;
import com.velocitypowered.api.command.CommandSource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.skinsrestorer.shadow.cloud.SenderMapper;
import net.skinsrestorer.shadow.cloud.execution.ExecutionCoordinator;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CloudInjectionModule<C>
extends AbstractModule {
    private final Class<C> commandSenderType;
    private final @NonNull ExecutionCoordinator<C> executionCoordinator;
    private final SenderMapper<CommandSource, C> senderMapper;

    public CloudInjectionModule(@NonNull Class<C> commandSenderType, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull SenderMapper<CommandSource, C> senderMapper) {
        this.commandSenderType = commandSenderType;
        this.executionCoordinator = executionCoordinator;
        this.senderMapper = senderMapper;
    }

    public static @NonNull CloudInjectionModule<@NonNull CommandSource> createNative(@NonNull ExecutionCoordinator<CommandSource> commandExecutionCoordinator) {
        return new CloudInjectionModule<CommandSource>(CommandSource.class, commandExecutionCoordinator, SenderMapper.identity());
    }

    protected void configure() {
        ParameterizedType commandExecutionCoordinatorType = Types.newParameterizedType(ExecutionCoordinator.class, (Type[])new Type[]{this.commandSenderType});
        Key executorFunctionKey = Key.get((Type)commandExecutionCoordinatorType);
        this.bind(executorFunctionKey).toInstance(this.executionCoordinator);
        ParameterizedType commandSenderMapperFunction = Types.newParameterizedType(SenderMapper.class, (Type[])new Type[]{CommandSource.class, this.commandSenderType});
        Key commandSenderMapperFunctionKey = Key.get((Type)commandSenderMapperFunction);
        this.bind(commandSenderMapperFunctionKey).toInstance(this.senderMapper);
    }
}

