/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cache;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.skinsrestorer.shadow.cloud.processors.cache.CloudCache;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE, since="1.0.0")
public final class SimpleCache<K, V>
implements CloudCache<K, V> {
    private final Map<K, V> map = Collections.synchronizedMap(new WeakHashMap());

    public static <K, V> @NonNull CloudCache<K, V> of() {
        return new SimpleCache<K, V>();
    }

    @Override
    public void delete(@NonNull K key) {
        Objects.requireNonNull(key, "key");
        this.map.remove(key);
    }

    @Override
    public void put(@NonNull K key, @NonNull V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.map.put(key, value);
    }

    @Override
    public @Nullable V getIfPresent(@NonNull K key) {
        Objects.requireNonNull(key, "key");
        return this.map.get(key);
    }

    @Override
    public @Nullable V popIfPresent(@NonNull K key) {
        Objects.requireNonNull(key, "key");
        return this.map.remove(key);
    }
}

