/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cache;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Objects;
import net.skinsrestorer.shadow.cloud.processors.cache.CloudCache;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE, since="1.0.0")
public final class CaffeineCache<K, V>
implements CloudCache<K, V> {
    private final Cache<K, V> cache;

    public static <K, V> @NonNull CloudCache<K, V> of(@NonNull Cache<K, V> cache) {
        return new CaffeineCache<K, V>(cache);
    }

    private CaffeineCache(@NonNull Cache<K, V> cache) {
        this.cache = Objects.requireNonNull(cache, "cache");
    }

    @Override
    public void delete(@NonNull K key) {
        Objects.requireNonNull(key, "key");
        this.cache.invalidate(key);
    }

    @Override
    public void put(@NonNull K key, @NonNull V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.cache.put(key, value);
    }

    @Override
    public @Nullable V getIfPresent(@NonNull K key) {
        Objects.requireNonNull(key, "key");
        return (V)this.cache.getIfPresent(key);
    }
}

