/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.scissors.skin;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.skinsrestorer.scissors.RectangleSection;
import net.skinsrestorer.scissors.skin.SkinSection;
import net.skinsrestorer.scissors.skin.SkinTag;
import net.skinsrestorer.scissors.skin.SkinVariant;
import net.skinsrestorer.shadow.javax.annotation.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="sections", type=Map.class), @RecordComponents.Value(name="variant", type=SkinVariant.class), @RecordComponents.Value(name="background", type=BufferedImage.class)})
public final class SkinDefinition
extends J_L_Record {
    private final Map<SkinSection, BufferedImage> sections;
    private final SkinVariant variant;
    @Nullable
    private final BufferedImage background;

    public SkinDefinition(Map<SkinSection, BufferedImage> sections, SkinVariant variant, @Nullable BufferedImage background) {
        this.sections = sections;
        this.variant = variant;
        this.background = background;
    }

    public static SkinDefinition extractFrom(BufferedImage skinImage, @Nullable SkinVariant skinVariant, boolean preserveCustomPixels) {
        RectangleSection rectangleSection;
        Graphics2D g;
        boolean isModernFormat;
        boolean isLegacyFormat = skinImage.getWidth() == 64 && skinImage.getHeight() == 32;
        boolean bl = isModernFormat = skinImage.getWidth() == 64 && skinImage.getHeight() == 64;
        if (!isLegacyFormat && !isModernFormat) {
            throw new IllegalArgumentException("Skin image must be 64x64 pixels!");
        }
        if (isLegacyFormat) {
            BufferedImage resizedImage = new BufferedImage(64, 64, 2);
            g = resizedImage.createGraphics();
            g.drawImage((Image)skinImage, 0, 0, null);
            g.dispose();
            skinImage = resizedImage;
            skinVariant = SkinVariant.CLASSIC;
        }
        if (skinVariant == null) {
            skinVariant = SkinVariant.detectVariant(skinImage);
        }
        BufferedImage backgroundImage = null;
        if (preserveCustomPixels) {
            backgroundImage = new BufferedImage(skinImage.getWidth(), skinImage.getHeight(), 2);
            g = backgroundImage.createGraphics();
            g.drawImage((Image)skinImage, 0, 0, null);
            g.dispose();
            for (SkinSection skinSection : SkinSection.VALUES) {
                rectangleSection = skinSection.getSectionVariants().get((Object)skinVariant);
                Graphics2D g2d = backgroundImage.createGraphics();
                g2d.setComposite(AlphaComposite.Clear);
                g2d.fillRect(rectangleSection.x(), rectangleSection.y(), rectangleSection.width(), rectangleSection.height());
                g2d.dispose();
            }
        }
        EnumMap<SkinSection, BufferedImage> map = new EnumMap<SkinSection, BufferedImage>(SkinSection.class);
        for (SkinSection skinSection : SkinSection.VALUES) {
            rectangleSection = skinSection.getSectionVariants().get((Object)skinVariant);
            BufferedImage subImage = skinImage.getSubimage(rectangleSection.x(), rectangleSection.y(), rectangleSection.width(), rectangleSection.height());
            map.put(skinSection, subImage);
        }
        if (isLegacyFormat) {
            for (SkinSection section : SkinSection.getTaggedSections(SkinTag.LEFT_LEG)) {
                map.put(section, map.get((Object)SkinSection.valueOf(section.name().replaceFirst("LEFT_", "RIGHT_"))));
            }
            for (SkinSection section : SkinSection.getTaggedSections(SkinTag.LEFT_ARM)) {
                map.put(section, map.get((Object)SkinSection.valueOf(section.name().replaceFirst("LEFT_", "RIGHT_"))));
            }
        }
        return new SkinDefinition(map, skinVariant, backgroundImage);
    }

    public BufferedImage export() {
        BufferedImage skinImage = new BufferedImage(64, 64, 2);
        Graphics2D g = skinImage.createGraphics();
        if (this.background != null) {
            g.drawImage((Image)this.background, 0, 0, null);
        }
        for (Map.Entry<SkinSection, BufferedImage> entry : this.sections.entrySet()) {
            SkinSection section = entry.getKey();
            BufferedImage sectionImage = entry.getValue();
            RectangleSection rectangleSection = section.getSectionVariants().get((Object)this.variant);
            g.drawImage((Image)sectionImage, rectangleSection.x(), rectangleSection.y(), null);
        }
        g.dispose();
        return skinImage;
    }

    @Override
    public final String toString() {
        return SkinDefinition.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return SkinDefinition.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return SkinDefinition.jvmdowngrader$equals$equals(this, o);
    }

    public Map<SkinSection, BufferedImage> sections() {
        return this.sections;
    }

    public SkinVariant variant() {
        return this.variant;
    }

    @Nullable
    public BufferedImage background() {
        return this.background;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(SkinDefinition skinDefinition) {
        SkinDefinition skinDefinition2 = skinDefinition;
        return "SkinDefinition[" + "sections=" + skinDefinition.sections + ", " + "variant=" + (Object)((Object)skinDefinition.variant) + ", " + "background=" + skinDefinition.background + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(SkinDefinition skinDefinition) {
        Object[] objectArray = new Object[]{skinDefinition.sections, skinDefinition.variant, skinDefinition.background};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(SkinDefinition skinDefinition, Object object) {
        if (skinDefinition == object) {
            return true;
        }
        if (object != null && object instanceof SkinDefinition) {
            SkinDefinition skinDefinition2 = (SkinDefinition)object;
            if (Objects.equals(skinDefinition.sections, skinDefinition2.sections) && Objects.equals((Object)skinDefinition.variant, (Object)skinDefinition2.variant) && Objects.equals(skinDefinition.background, skinDefinition2.background)) {
                return true;
            }
        }
        return false;
    }
}

