/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.scissors;

import java.awt.Color;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={HSBA.class, ARGB.class})
public interface ARGBPixelProcessor
extends IntUnaryOperator {
    public static ARGBPixelProcessor of(IntUnaryOperator op) {
        ARGBPixelProcessor processor;
        return op instanceof ARGBPixelProcessor ? (processor = (ARGBPixelProcessor)op) : op::applyAsInt;
    }

    @Override
    public int applyAsInt(int var1);

    @Override
    @NotNull
    default public ARGBPixelProcessor compose(@NotNull IntUnaryOperator before) {
        return pixel -> this.applyAsInt(before.applyAsInt(pixel));
    }

    @Override
    @NotNull
    default public ARGBPixelProcessor andThen(@NotNull IntUnaryOperator after) {
        return pixel -> after.applyAsInt(this.applyAsInt(pixel));
    }

    @NotNull
    public static ARGBPixelProcessor identity() {
        return pixel -> pixel;
    }

    public static ARGBPixelProcessor grayscale() {
        return pixel -> {
            ARGB argb = new ARGB(pixel);
            int gray = (argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$red() + argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$green() + argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$blue()) / 3;
            return new ARGB(argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$alpha(), gray, gray, gray).toInt();
        };
    }

    public static ARGBPixelProcessor invert() {
        return pixel -> {
            ARGB argb = new ARGB(pixel);
            return new ARGB(argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$alpha(), 255 - argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$red(), 255 - argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$green(), 255 - argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$blue()).toInt();
        };
    }

    public static ARGBPixelProcessor alphaTint(int tint) {
        return pixel -> {
            ARGB argb = new ARGB(pixel);
            int alpha = argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$alpha() * tint / 255;
            return new ARGB(alpha, argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$red(), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$green(), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$blue()).toInt();
        };
    }

    public static ARGBPixelProcessor redTint(int tint) {
        return pixel -> {
            ARGB argb = new ARGB(pixel);
            int red = argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$red() * tint / 255;
            return new ARGB(argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$alpha(), red, argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$green(), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$blue()).toInt();
        };
    }

    public static ARGBPixelProcessor greenTint(int tint) {
        return pixel -> {
            ARGB argb = new ARGB(pixel);
            int green = argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$green() * tint / 255;
            return new ARGB(argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$alpha(), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$red(), green, argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$blue()).toInt();
        };
    }

    public static ARGBPixelProcessor blueTint(int tint) {
        return pixel -> {
            ARGB argb = new ARGB(pixel);
            int blue = argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$blue() * tint / 255;
            return new ARGB(argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$alpha(), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$red(), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$green(), blue).toInt();
        };
    }

    public static ARGBPixelProcessor adjustHue(float hueAdjustment) {
        return pixel -> {
            HSBA hsba = new HSBA(pixel);
            float newHue = (hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$hue() + hueAdjustment) % 1.0f;
            if (newHue < 0.0f) {
                newHue += 1.0f;
            }
            return new HSBA(newHue, hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$saturation(), hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$brightness(), hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$alpha()).toARGB();
        };
    }

    public static ARGBPixelProcessor adjustSaturation(float saturationFactor) {
        return pixel -> {
            HSBA hsba = new HSBA(pixel);
            float newSaturation = Math.min(Math.max(hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$saturation() * saturationFactor, 0.0f), 1.0f);
            return new HSBA(hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$hue(), newSaturation, hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$brightness(), hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$alpha()).toARGB();
        };
    }

    public static ARGBPixelProcessor adjustBrightness(float brightnessFactor) {
        return pixel -> {
            HSBA hsba = new HSBA(pixel);
            float newBrightness = Math.min(Math.max(hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$brightness() * brightnessFactor, 0.0f), 1.0f);
            return new HSBA(hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$hue(), hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$saturation(), newBrightness, hsba.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$alpha()).toARGB();
        };
    }

    @RecordComponents(value={@RecordComponents.Value(name="hue", type=float.class), @RecordComponents.Value(name="saturation", type=float.class), @RecordComponents.Value(name="brightness", type=float.class), @RecordComponents.Value(name="alpha", type=int.class)})
    @NestHost(value=ARGBPixelProcessor.class)
    public static final class HSBA
    extends J_L_Record {
        private final float hue;
        private final float saturation;
        private final float brightness;
        private final int alpha;

        public HSBA(int argb) {
            this(new ARGB(argb));
        }

        public HSBA(ARGB argb) {
            this(Color.RGBtoHSB(argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$red(), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$green(), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$blue(), null), argb.jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$alpha());
        }

        public HSBA(float[] hsb, int alpha) {
            this(hsb[0], hsb[1], hsb[2], alpha);
        }

        public HSBA(float hue, float saturation, float brightness, int alpha) {
            this.hue = hue;
            this.saturation = saturation;
            this.brightness = brightness;
            this.alpha = alpha;
        }

        public int toARGB() {
            int rgb = Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
            return new ARGB(this.alpha, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF).toInt();
        }

        @Override
        public final String toString() {
            return HSBA.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return HSBA.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return HSBA.jvmdowngrader$equals$equals(this, o);
        }

        public float hue() {
            return this.hue;
        }

        public float saturation() {
            return this.saturation;
        }

        public float brightness() {
            return this.brightness;
        }

        public int alpha() {
            return this.alpha;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(HSBA hSBA) {
            HSBA hSBA2 = hSBA;
            return "ARGBPixelProcessor$HSBA[" + "hue=" + hSBA.hue + ", " + "saturation=" + hSBA.saturation + ", " + "brightness=" + hSBA.brightness + ", " + "alpha=" + hSBA.alpha + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(HSBA hSBA) {
            Object[] objectArray = new Object[]{Float.valueOf(hSBA.hue), Float.valueOf(hSBA.saturation), Float.valueOf(hSBA.brightness), hSBA.alpha};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(HSBA hSBA, Object object) {
            if (hSBA == object) {
                return true;
            }
            if (object != null && object instanceof HSBA) {
                HSBA hSBA2 = (HSBA)object;
                if (hSBA.hue == hSBA2.hue && hSBA.saturation == hSBA2.saturation && hSBA.brightness == hSBA2.brightness && hSBA.alpha == hSBA2.alpha) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ float jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$saturation() {
            return this.saturation;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$set$saturation(float f) {
            this.saturation = f;
        }

        public /* synthetic */ float jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$hue() {
            return this.hue;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$set$hue(float f) {
            this.hue = f;
        }

        public /* synthetic */ float jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$brightness() {
            return this.brightness;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$set$brightness(float f) {
            this.brightness = f;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$get$alpha() {
            return this.alpha;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$HSBA$set$alpha(int n) {
            this.alpha = n;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="alpha", type=int.class), @RecordComponents.Value(name="red", type=int.class), @RecordComponents.Value(name="green", type=int.class), @RecordComponents.Value(name="blue", type=int.class)})
    @NestHost(value=ARGBPixelProcessor.class)
    public static final class ARGB
    extends J_L_Record {
        private final int alpha;
        private final int red;
        private final int green;
        private final int blue;

        public ARGB(int argb) {
            this(argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF);
        }

        public ARGB(int alpha, int red, int green, int blue) {
            this.alpha = alpha;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public int toInt() {
            return this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
        }

        @Override
        public final String toString() {
            return ARGB.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ARGB.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ARGB.jvmdowngrader$equals$equals(this, o);
        }

        public int alpha() {
            return this.alpha;
        }

        public int red() {
            return this.red;
        }

        public int green() {
            return this.green;
        }

        public int blue() {
            return this.blue;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(ARGB aRGB) {
            ARGB aRGB2 = aRGB;
            return "ARGBPixelProcessor$ARGB[" + "alpha=" + aRGB.alpha + ", " + "red=" + aRGB.red + ", " + "green=" + aRGB.green + ", " + "blue=" + aRGB.blue + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(ARGB aRGB) {
            Object[] objectArray = new Object[]{aRGB.alpha, aRGB.red, aRGB.green, aRGB.blue};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(ARGB aRGB, Object object) {
            if (aRGB == object) {
                return true;
            }
            if (object != null && object instanceof ARGB) {
                ARGB aRGB2 = (ARGB)object;
                if (aRGB.alpha == aRGB2.alpha && aRGB.red == aRGB2.red && aRGB.green == aRGB2.green && aRGB.blue == aRGB2.blue) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$red() {
            return this.red;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$set$red(int n) {
            this.red = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$green() {
            return this.green;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$set$green(int n) {
            this.green = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$blue() {
            return this.blue;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$set$blue(int n) {
            this.blue = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$get$alpha() {
            return this.alpha;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_scissors_ARGBPixelProcessor$ARGB$set$alpha(int n) {
            this.alpha = n;
        }
    }
}

