/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bungee.wrapper.WrapperBungee;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.reflect.exceptions.ConstructorNotFoundException;
import net.skinsrestorer.shadow.reflect.stream.RStream;
import net.skinsrestorer.shadow.reflect.stream.field.FieldWrapper;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import net.skinsrestorer.shared.utils.AuthLibHelper;
import net.skinsrestorer.shared.utils.ProxyAckTracker;

public class SkinApplierBungee
implements SkinApplierAccess<ProxiedPlayer> {
    private final WrapperBungee wrapper;
    private final EventBusImpl eventBus;
    private final ProxyAckTracker proxyAckTracker;

    public static void applyToHandler(PendingConnection handler, SkinProperty property) {
        FieldWrapper loginProfileFieldWrapper = RStream.of(handler).withSuper().fields().by("loginProfile");
        Class<?> loginProfileClass = loginProfileFieldWrapper.type();
        Object loginProfile = loginProfileFieldWrapper.get();
        FieldWrapper propertyArrayFieldWrapper = RStream.of(loginProfileFieldWrapper.type()).fields().by("properties");
        Class<?> propertyArrayClass = propertyArrayFieldWrapper.type();
        Class<?> propertyClass = propertyArrayClass.getComponentType();
        Object propertyArray = Array.newInstance(propertyClass, 1);
        Array.set(propertyArray, 0, RStream.of(propertyClass).constructors().by(String.class, String.class, String.class).newInstance("textures", property.getValue(), property.getSignature()));
        if (loginProfile == null) {
            try {
                loginProfileFieldWrapper.set(RStream.of(loginProfileClass).constructors().by(String.class, String.class, propertyArrayClass).newInstance(null, null, propertyArray));
            }
            catch (ConstructorNotFoundException ignored) {
                loginProfileFieldWrapper.set(RStream.of(loginProfileClass).constructors().by(String.class, propertyArrayClass).newInstance(null, propertyArray));
            }
        } else {
            propertyArrayFieldWrapper.set(loginProfile, propertyArray);
        }
    }

    public static Optional<SkinProperty> getSkinProperty(ProxiedPlayer player) {
        Object[] properties = (Object[])RStream.of(player.getPendingConnection()).withSuper().fields().by("loginProfile").stream().fields().by("properties").get();
        if (properties == null) {
            return Optional.empty();
        }
        return Arrays.stream(properties).map(property -> SkinProperty.tryParse(AuthLibHelper.getPropertyName(property), AuthLibHelper.getPropertyValue(property), AuthLibHelper.getPropertySignature(property))).flatMap(J_U_Optional::stream).findFirst();
    }

    @Override
    public void applySkin(ProxiedPlayer player, SkinProperty property) {
        this.applyEvent(player, property, player.getPendingConnection());
    }

    public void applySkin(SkinProperty property, PendingConnection handler) {
        this.applyEvent(null, property, handler);
    }

    private void applyEvent(@Nullable ProxiedPlayer player, SkinProperty property, PendingConnection handler) {
        SkinApplyEventImpl event = new SkinApplyEventImpl(player, property);
        this.eventBus.callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.applyWithProperty(player, handler, event.getProperty());
    }

    private void applyWithProperty(@Nullable ProxiedPlayer player, PendingConnection handler, SkinProperty property) {
        SkinApplierBungee.applyToHandler(handler, property);
        if (player == null) {
            return;
        }
        SRProxyPlayer srPlayer = this.wrapper.player(player);
        srPlayer.sendToMessageChannel(new SRServerPluginMessage(new SRServerPluginMessage.SkinUpdateV3ChannelPayload(property, this.proxyAckTracker.shouldAckPayload(srPlayer))));
    }

    @Inject
    @Generated
    public SkinApplierBungee(WrapperBungee wrapper, EventBusImpl eventBus, ProxyAckTracker proxyAckTracker) {
        this.wrapper = wrapper;
        this.eventBus = eventBus;
        this.proxyAckTracker = proxyAckTracker;
    }
}

