/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.skinsrestorer.bukkit.mappings.IMapping;
import net.skinsrestorer.bukkit.mappings.Mapping1_18;
import net.skinsrestorer.bukkit.mappings.Mapping1_18_2;
import net.skinsrestorer.bukkit.mappings.Mapping1_19;
import net.skinsrestorer.bukkit.mappings.Mapping1_19_1;
import net.skinsrestorer.bukkit.mappings.Mapping1_19_2;
import net.skinsrestorer.bukkit.mappings.Mapping1_19_3;
import net.skinsrestorer.bukkit.mappings.Mapping1_19_4;
import net.skinsrestorer.bukkit.mappings.Mapping1_20;
import net.skinsrestorer.bukkit.mappings.Mapping1_20_2;
import net.skinsrestorer.bukkit.mappings.Mapping1_20_4;
import net.skinsrestorer.bukkit.mappings.Mapping1_20_5;
import net.skinsrestorer.bukkit.mappings.Mapping1_21;
import net.skinsrestorer.bukkit.mappings.Mapping1_21_11;
import net.skinsrestorer.bukkit.mappings.Mapping1_21_2;
import net.skinsrestorer.bukkit.mappings.Mapping1_21_4;
import net.skinsrestorer.bukkit.mappings.Mapping1_21_5;
import net.skinsrestorer.bukkit.mappings.Mapping1_21_6;
import net.skinsrestorer.bukkit.mappings.Mapping1_21_9;
import net.skinsrestorer.bukkit.paper.PaperUtil;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import org.bukkit.Server;
import org.bukkit.UnsafeValues;

public class MappingManager {
    private static final List<IMapping> MAPPINGS = J_U_List.of(new IMapping[]{new Mapping1_18(), new Mapping1_18_2(), new Mapping1_19(), new Mapping1_19_1(), new Mapping1_19_2(), new Mapping1_19_3(), new Mapping1_19_4(), new Mapping1_20(), new Mapping1_20_2(), new Mapping1_20_4(), new Mapping1_20_5(), new Mapping1_21(), new Mapping1_21_2(), new Mapping1_21_4(), new Mapping1_21_5(), new Mapping1_21_6(), new Mapping1_21_9(), new Mapping1_21_11()});

    public static Optional<IMapping> getMapping(Server server) {
        Optional<String> spigotMappingVersion = MappingManager.getSpigotMappingVersion(server);
        Optional<String> paperMinecraftVersionId = MappingManager.getPaperMinecraftVersionId();
        if (J_U_Optional.isEmpty(spigotMappingVersion) && J_U_Optional.isEmpty(paperMinecraftVersionId)) {
            return Optional.empty();
        }
        Predicate<IMapping> isSupportedSpigotMapping = mapping -> spigotMappingVersion.map(mapping.getSpigotMappingVersions()::contains).orElse(false);
        Predicate<IMapping> isSupportedPaperMapping = mapping -> paperMinecraftVersionId.map(mapping.getPaperMinecraftVersionIds()::contains).orElse(false);
        return MAPPINGS.stream().filter(mapping -> isSupportedSpigotMapping.test((IMapping)mapping) || isSupportedPaperMapping.test((IMapping)mapping)).findFirst();
    }

    public static Optional<String> getSpigotMappingVersion(Server server) {
        UnsafeValues craftMagicNumbers = server.getUnsafe();
        try {
            Method method = craftMagicNumbers.getClass().getMethod("getMappingsVersion", new Class[0]);
            return ((String)method.invoke((Object)craftMagicNumbers, new Object[0])).describeConstable();
        }
        catch (ReflectiveOperationException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> getPaperMinecraftVersionId() {
        return PaperUtil.getMinecraftVersionId();
    }
}

