/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bukkit.utils.SkinApplyBukkitAdapter;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.reflect.stream.RStream;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.utils.AuthLibHelper;
import org.bukkit.entity.Player;

public class BukkitPropertyApplier
implements SkinApplyBukkitAdapter {
    private static final Method GET_PROPERTIES_METHOD;
    private static final Constructor<?> PROPERTY_CLASS_CONSTRUCTOR;
    private final SRLogger logger;

    @Override
    public void applyProperty(Player player, SkinProperty property) {
        try {
            Multimap properties = (Multimap)GET_PROPERTIES_METHOD.invoke(this.getGameProfile(player), new Object[0]);
            ImmutableMultimap.Builder newProperties = ImmutableMultimap.builder();
            for (Map.Entry entry : properties.entries()) {
                if ("textures".equals(entry.getKey())) continue;
                newProperties.put(entry);
            }
            newProperties.put((Object)"textures", PROPERTY_CLASS_CONSTRUCTOR.newInstance("textures", property.getValue(), property.getSignature()));
            RStream.of(properties).withSuper().fields().by("properties").set(newProperties.build());
        }
        catch (ReflectiveOperationException e) {
            this.logger.severe(J_L_String.formatted("Failed to apply skin property to player %s", player.getName()), e);
        }
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(Player player) {
        try {
            return ((Multimap)GET_PROPERTIES_METHOD.invoke(this.getGameProfile(player), new Object[0])).values().stream().map(property -> SkinProperty.tryParse(AuthLibHelper.getPropertyName(property), AuthLibHelper.getPropertyValue(property), AuthLibHelper.getPropertySignature(property))).flatMap(J_U_Optional::stream).findFirst();
        }
        catch (ReflectiveOperationException e) {
            this.logger.severe(J_L_String.formatted("Failed to get skin property from player %s", player.getName()), e);
            return Optional.empty();
        }
    }

    @Inject
    @Generated
    public BukkitPropertyApplier(SRLogger logger) {
        this.logger = logger;
    }

    static {
        Constructor<?> propertyClass;
        Method getPropertiesMethod;
        Class<?> gameProfileClass;
        try {
            gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
        }
        catch (ClassNotFoundException e) {
            try {
                gameProfileClass = Class.forName("net.minecraft.util.com.mojang.authlib.GameProfile");
            }
            catch (ClassNotFoundException ex) {
                ExceptionInInitializerError error = new ExceptionInInitializerError("Failed to find GameProfile class");
                error.addSuppressed(ex);
                error.addSuppressed(e);
                throw error;
            }
        }
        try {
            getPropertiesMethod = gameProfileClass.getMethod("getProperties", new Class[0]);
        }
        catch (NoSuchMethodException e1) {
            try {
                getPropertiesMethod = gameProfileClass.getMethod("properties", new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                ExceptionInInitializerError error = new ExceptionInInitializerError("Failed to find getProperties method");
                error.addSuppressed(e1);
                error.addSuppressed(e2);
                throw error;
            }
        }
        GET_PROPERTIES_METHOD = getPropertiesMethod;
        try {
            propertyClass = Class.forName("com.mojang.authlib.properties.Property").getConstructor(String.class, String.class, String.class);
        }
        catch (ReflectiveOperationException e) {
            try {
                propertyClass = Class.forName("net.minecraft.util.com.mojang.authlib.properties.Property").getConstructor(String.class, String.class, String.class);
            }
            catch (ReflectiveOperationException ex) {
                ExceptionInInitializerError error = new ExceptionInInitializerError("Failed to find Property class");
                error.addSuppressed(ex);
                error.addSuppressed(e);
                throw error;
            }
        }
        PROPERTY_CLASS_CONSTRUCTOR = propertyClass;
    }
}

