/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.refresher;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.bukkit.mappings.IMapping;
import net.skinsrestorer.bukkit.refresher.SkinRefresher;
import net.skinsrestorer.bukkit.utils.BukkitReflection;
import net.skinsrestorer.bukkit.utils.HandleReflection;
import net.skinsrestorer.bukkit.utils.OPRefreshUtil;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import net.skinsrestorer.shared.utils.SRHelpers;
import net.skinsrestorer.viaversion.ViaRefreshProvider;
import org.bukkit.Location;
import org.bukkit.WorldType;
import org.bukkit.entity.Player;

public final class SpigotSkinRefresher
implements SkinRefresher {
    private final SRBukkitAdapter adapter;
    private final SRLogger logger;
    private final ViaRefreshProvider viaProvider;
    private final Class<?> playOutRespawnClass;
    private final Class<?> playOutPlayerInfoClass;
    private final Class<?> playOutPositionClass;
    private final Class<?> packetClass;
    private final Class<?> playOutHeldItemSlotClass;
    private final Enum<?> removePlayerEnum;
    private final Enum<?> addPlayerEnum;

    @Inject
    public SpigotSkinRefresher(SRBukkitAdapter adapter, SRLogger logger, ViaRefreshProvider viaProvider) {
        this.adapter = adapter;
        this.logger = logger;
        this.viaProvider = viaProvider;
        try {
            Enum<?> addPlayerEnum;
            Enum<?> removePlayerEnum;
            this.packetClass = BukkitReflection.getNMSClass("Packet", "net.minecraft.network.protocol.Packet");
            this.playOutHeldItemSlotClass = BukkitReflection.getNMSClass("PacketPlayOutHeldItemSlot", "net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot");
            this.playOutPositionClass = BukkitReflection.getNMSClass("PacketPlayOutPosition", "net.minecraft.network.protocol.game.PacketPlayOutPosition");
            this.playOutPlayerInfoClass = BukkitReflection.getNMSClass("PacketPlayOutPlayerInfo", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo");
            this.playOutRespawnClass = BukkitReflection.getNMSClass("PacketPlayOutRespawn", "net.minecraft.network.protocol.game.PacketPlayOutRespawn");
            try {
                removePlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfoClass, "EnumPlayerInfoAction", "REMOVE_PLAYER");
                addPlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfoClass, "EnumPlayerInfoAction", "ADD_PLAYER");
            }
            catch (ReflectiveOperationException e1) {
                try {
                    Class<?> enumPlayerInfoActionClass = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$EnumPlayerInfoAction");
                    removePlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoActionClass, 4);
                    addPlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoActionClass, 0);
                }
                catch (ReflectiveOperationException e2) {
                    try {
                        removePlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfoClass, "Action", "REMOVE_PLAYER");
                        addPlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfoClass, "Action", "ADD_PLAYER");
                    }
                    catch (ReflectiveOperationException e3) {
                        try {
                            Class<?> enumPlayerInfoAction = BukkitReflection.getNMSClass("EnumPlayerInfoAction", null);
                            removePlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoAction, "REMOVE_PLAYER");
                            addPlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoAction, "ADD_PLAYER");
                        }
                        catch (ReflectiveOperationException e4) {
                            removePlayerEnum = null;
                            addPlayerEnum = null;
                        }
                    }
                }
            }
            this.removePlayerEnum = removePlayerEnum;
            this.addPlayerEnum = addPlayerEnum;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to initialize SpigotSkinRefresher", e);
        }
    }

    private void sendPacket(Player player, Object packet) throws ReflectiveOperationException {
        Object entityPlayer = HandleReflection.getHandle(player, Object.class);
        Object playerCon = ReflectionUtil.getFieldByType(entityPlayer, "PlayerConnection");
        ReflectionUtil.invokeObjectMethod(playerCon, "sendPacket", new ReflectionUtil.ParameterPair<Object>(this.packetClass, packet));
    }

    @Override
    public void refresh(Player player) {
        try {
            Object pos;
            Object respawn;
            Object worldType;
            Object worldData;
            Object difficulty;
            Object entityPlayer = HandleReflection.getHandle(player, Object.class);
            Object world = ReflectionUtil.invokeObjectMethod(entityPlayer, "getWorld", new ReflectionUtil.ParameterPair[0]);
            try {
                difficulty = ReflectionUtil.invokeObjectMethod(world, "getDifficulty", new ReflectionUtil.ParameterPair[0]);
            }
            catch (ReflectiveOperationException e) {
                difficulty = ReflectionUtil.getObject(world, "difficulty");
            }
            try {
                worldData = ReflectionUtil.invokeObjectMethod(world, "getWorldData", new ReflectionUtil.ParameterPair[0]);
            }
            catch (ReflectiveOperationException ignored) {
                worldData = ReflectionUtil.getObject(world, "worldData");
            }
            try {
                worldType = ReflectionUtil.invokeObjectMethod(worldData, "getType", new ReflectionUtil.ParameterPair[0]);
            }
            catch (ReflectiveOperationException ignored) {
                worldType = ReflectionUtil.invokeObjectMethod(worldData, "getGameType", new ReflectionUtil.ParameterPair[0]);
            }
            Object playerIntManager = ReflectionUtil.getFieldByType(entityPlayer, "PlayerInteractManager");
            Enum enumGamemode = (Enum)ReflectionUtil.invokeObjectMethod(playerIntManager, "getGameMode", new ReflectionUtil.ParameterPair[0]);
            int gamemodeId = player.getGameMode().getValue();
            int dimension = player.getWorld().getEnvironment().getId();
            try {
                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawnClass, dimension, difficulty, worldType, enumGamemode);
            }
            catch (Exception ignored) {
                Object worldObject = ReflectionUtil.getFieldByType(entityPlayer, "World");
                Object dimensionManager = this.getDimensionManager(worldObject, dimension);
                try {
                    respawn = ReflectionUtil.invokeConstructor(this.playOutRespawnClass, dimensionManager, difficulty, worldType, enumGamemode);
                }
                catch (ReflectiveOperationException ignored2) {
                    try {
                        respawn = ReflectionUtil.invokeConstructor(this.playOutRespawnClass, dimensionManager, worldType, enumGamemode);
                    }
                    catch (ReflectiveOperationException ignored3) {
                        long seedEncrypted = SRHelpers.hashSha256ToLong(String.valueOf(player.getWorld().getSeed()));
                        try {
                            respawn = ReflectionUtil.invokeConstructor(this.playOutRespawnClass, dimensionManager, seedEncrypted, worldType, enumGamemode);
                        }
                        catch (ReflectiveOperationException ignored5) {
                            Object dimensionKey = ReflectionUtil.invokeObjectMethod(worldObject, "getDimensionKey", new ReflectionUtil.ParameterPair[0]);
                            boolean debug = (Boolean)ReflectionUtil.invokeObjectMethod(worldObject, "isDebugWorld", new ReflectionUtil.ParameterPair[0]);
                            boolean flat = SpigotSkinRefresher.isFlatWorld(player);
                            List<Object> gameModeList = ReflectionUtil.getFieldByTypeList(playerIntManager, "EnumGamemode");
                            Enum enumGamemodePrevious = (Enum)this.getFromListExcluded(gameModeList, enumGamemode);
                            try {
                                Object typeKey = ReflectionUtil.invokeObjectMethod(worldObject, "getTypeKey", new ReflectionUtil.ParameterPair[0]);
                                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawnClass, typeKey, dimensionKey, seedEncrypted, enumGamemode, enumGamemodePrevious, debug, flat, true);
                            }
                            catch (ReflectiveOperationException ignored6) {
                                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawnClass, dimensionManager, dimensionKey, seedEncrypted, enumGamemode, enumGamemodePrevious, debug, flat, true);
                            }
                        }
                    }
                }
            }
            Location l = player.getLocation();
            try {
                pos = ReflectionUtil.invokeConstructor(this.playOutPositionClass, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet(), 0, false);
            }
            catch (ReflectiveOperationException e1) {
                try {
                    pos = ReflectionUtil.invokeConstructor(this.playOutPositionClass, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet(), 0);
                }
                catch (ReflectiveOperationException e2) {
                    try {
                        pos = ReflectionUtil.invokeConstructor(this.playOutPositionClass, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet());
                    }
                    catch (ReflectiveOperationException e3) {
                        pos = ReflectionUtil.invokeConstructor(this.playOutPositionClass, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), false);
                    }
                }
            }
            Object slot = ReflectionUtil.invokeConstructor(this.playOutHeldItemSlotClass, player.getInventory().getHeldItemSlot());
            this.resendInfoPackets(player, player);
            boolean sendRespawnPacketDirectly = this.viaProvider.test(() -> IMapping.newViaPacketData(player, SRHelpers.hashSha256ToLong(String.valueOf(player.getWorld().getSeed())), Integer.valueOf(gamemodeId).shortValue(), SpigotSkinRefresher.isFlatWorld(player)));
            if (sendRespawnPacketDirectly) {
                this.sendPacket(player, respawn);
            }
            ReflectionUtil.invokeObjectMethod(entityPlayer, "updateAbilities", new ReflectionUtil.ParameterPair[0]);
            this.sendPacket(player, pos);
            this.sendPacket(player, slot);
            ReflectionUtil.invokeObjectMethod(player, "updateScaledHealth", new ReflectionUtil.ParameterPair[0]);
            player.updateInventory();
            ReflectionUtil.invokeObjectMethod(entityPlayer, "triggerHealthUpdate", new ReflectionUtil.ParameterPair[0]);
            OPRefreshUtil.refreshOP(player, this.adapter);
        }
        catch (ReflectiveOperationException e) {
            this.logger.severe(J_L_String.formatted("Failed to refresh skin for player %s because of %s (more info in debug)", player.getName(), e.getClass().getSimpleName()));
            this.logger.debug(e);
        }
    }

    private static boolean isFlatWorld(Player player) {
        return player.getWorld().getWorldType() == WorldType.FLAT;
    }

    @Override
    public void resendInfoPackets(Player toResend, Player toSendTo) {
        Object addPlayer;
        Object removePlayer;
        Object entityPlayer = HandleReflection.getHandle(toResend, Object.class);
        try {
            removePlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfoClass, this.removePlayerEnum, J_U_List.of(entityPlayer));
            addPlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfoClass, this.addPlayerEnum, J_U_List.of(entityPlayer));
        }
        catch (ReflectiveOperationException e) {
            try {
                int ping = (Integer)ReflectionUtil.getObject(entityPlayer, "ping");
                removePlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfoClass, toResend.getPlayerListName(), false, 9999);
                addPlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfoClass, toResend.getPlayerListName(), true, ping);
            }
            catch (ReflectiveOperationException e2) {
                removePlayer = ReflectionUtil.invokeStaticMethod(this.playOutPlayerInfoClass, "removePlayer", new ReflectionUtil.ParameterPair<Object>(entityPlayer));
                addPlayer = ReflectionUtil.invokeStaticMethod(this.playOutPlayerInfoClass, "addPlayer", new ReflectionUtil.ParameterPair<Object>(entityPlayer));
            }
        }
        this.sendPacket(toSendTo, removePlayer);
        this.sendPacket(toSendTo, addPlayer);
    }

    private Object getFromListExcluded(List<Object> list, Object ... excluded) {
        for (Object obj : list) {
            if (obj == excluded) continue;
            return obj;
        }
        return null;
    }

    private Object getDimensionManager(Object worldObject, int dimension) throws ReflectiveOperationException {
        try {
            return ReflectionUtil.getFieldByType(worldObject, "DimensionManager");
        }
        catch (ReflectiveOperationException e) {
            try {
                Class<?> dimensionManagerClass = BukkitReflection.getNMSClass("DimensionManager", "net.minecraft.world.level.dimension.DimensionManager");
                for (Method m : dimensionManagerClass.getDeclaredMethods()) {
                    if (m.getReturnType() != dimensionManagerClass || m.getParameterCount() != 1 || m.getParameterTypes()[0] != Integer.TYPE) continue;
                    m.setAccessible(true);
                    return m.invoke(null, dimension);
                }
            }
            catch (ReflectiveOperationException e2) {
                this.logger.severe(J_L_String.formatted("Failed to get DimensionManager from %s", worldObject.getClass().getSimpleName()), e2);
            }
            throw new ReflectiveOperationException(J_L_String.formatted("Could not get DimensionManager from %s", worldObject.getClass().getSimpleName()));
        }
    }
}

