/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.listener;

import lombok.Generated;
import net.skinsrestorer.bukkit.gui.BukkitGUIHolder;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.log.SRLogger;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class InventoryListener
implements Listener {
    private final SRLogger logger;

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory topInventory = event.getView().getTopInventory();
        InventoryHolder holder = topInventory.getHolder();
        if (holder instanceof BukkitGUIHolder) {
            BukkitGUIHolder guiHolder = (BukkitGUIHolder)holder;
            if (this.isInTop(topInventory, event.getRawSlot())) {
                try {
                    guiHolder.onClick(event);
                }
                catch (Throwable e) {
                    this.logger.severe("Failed to handle inventory click event", e);
                }
            }
            event.setCancelled(true);
        }
    }

    public boolean isInTop(Inventory topInventory, int rawSlot) {
        return rawSlot < topInventory.getSize();
    }

    @Inject
    @Generated
    public InventoryListener(SRLogger logger) {
        this.logger = logger;
    }
}

