/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.hooks;

import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bukkit.utils.SkinApplyBukkitAdapter;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.storage.HardcodedSkins;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginDescriptionFile;

public class SRPlaceholderAPIExpansion
extends PlaceholderExpansion {
    private static final String ERROR_MESSAGE = "Error";
    private final SRLogger logger;
    private final PluginDescriptionFile description;
    private final Injector injector;

    @NotNull
    public String getIdentifier() {
        return "skinsrestorer";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.description.getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.description.getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        if ((params = params.toLowerCase(Locale.ROOT)).startsWith("skin_name")) {
            if (offlinePlayer == null) {
                return ERROR_MESSAGE;
            }
            Optional<SkinIdentifier> skin = SkinsRestorerProvider.get().getPlayerStorage().getSkinIdOfPlayer(offlinePlayer.getUniqueId());
            if (skin.isPresent()) {
                return skin.get().getIdentifier();
            }
            if (params.startsWith("skin_name_")) {
                String subString = params.substring("skin_name_".length());
                if (subString.equalsIgnoreCase("or_empty")) {
                    return "";
                }
                if (subString.equalsIgnoreCase("or_player_name")) {
                    return offlinePlayer.getName();
                }
            }
            return ERROR_MESSAGE;
        }
        if (params.startsWith("texture_url")) {
            if (offlinePlayer == null) {
                return ERROR_MESSAGE;
            }
            try {
                Optional<SkinProperty> skin = this.getCurrentProperties(offlinePlayer);
                if (skin.isPresent()) {
                    return this.extractTextureUrl(skin.get());
                }
                if (params.startsWith("texture_url_")) {
                    String subString = params.substring("texture_url_".length());
                    if (subString.equalsIgnoreCase("or_empty")) {
                        return "";
                    }
                    if (subString.equalsIgnoreCase("or_steve")) {
                        return this.extractTextureUrl(HardcodedSkins.STEVE.getProperty());
                    }
                    if (subString.equalsIgnoreCase("or_alex")) {
                        return this.extractTextureUrl(HardcodedSkins.ALEX.getProperty());
                    }
                }
            }
            catch (DataRequestException e) {
                this.logger.severe(J_L_String.formatted("Failed to get skin data of player %s", offlinePlayer.getUniqueId()), e);
            }
            return ERROR_MESSAGE;
        }
        if (params.startsWith("texture_id")) {
            if (offlinePlayer == null) {
                return ERROR_MESSAGE;
            }
            try {
                Optional<SkinProperty> skin = this.getCurrentProperties(offlinePlayer);
                if (skin.isPresent()) {
                    return this.extractTextureHash(skin.get());
                }
                if (params.startsWith("texture_id_")) {
                    String subString = params.substring("texture_id_".length());
                    if (subString.equalsIgnoreCase("or_empty")) {
                        return "";
                    }
                    if (subString.equalsIgnoreCase("or_steve")) {
                        return this.extractTextureHash(HardcodedSkins.STEVE.getProperty());
                    }
                    if (subString.equalsIgnoreCase("or_alex")) {
                        return this.extractTextureHash(HardcodedSkins.ALEX.getProperty());
                    }
                }
            }
            catch (DataRequestException e) {
                this.logger.severe(J_L_String.formatted("Failed to get skin data of player %s", offlinePlayer.getUniqueId()), e);
            }
            return ERROR_MESSAGE;
        }
        return null;
    }

    private String extractTextureUrl(SkinProperty property) {
        return PropertyUtils.getSkinTextureUrl(property);
    }

    private String extractTextureHash(SkinProperty property) {
        return PropertyUtils.getSkinTextureHash(property);
    }

    private Optional<SkinProperty> getCurrentProperties(OfflinePlayer offlinePlayer) throws DataRequestException {
        if (offlinePlayer instanceof Player) {
            Player player = (Player)offlinePlayer;
            return this.injector.getSingleton(SkinApplyBukkitAdapter.class).getSkinProperty(player);
        }
        return SkinsRestorerProvider.get().getPlayerStorage().getSkinForPlayer(offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    @Generated
    public SRPlaceholderAPIExpansion(SRLogger logger, PluginDescriptionFile description, Injector injector) {
        this.logger = logger;
        this.description = description;
        this.injector = injector;
    }
}

