/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.gui;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.gui.ActionDataCallback;
import net.skinsrestorer.shared.gui.ClickEventType;
import net.skinsrestorer.shared.gui.SRInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class BukkitGUIHolder
implements InventoryHolder {
    private final ActionDataCallback dataCallback;
    private final WrapperBukkit wrapper;
    private final Map<Integer, Map<ClickEventType, SRInventory.ClickEventAction>> handlers = new HashMap<Integer, Map<ClickEventType, SRInventory.ClickEventAction>>();
    private Inventory inventory;

    public void onClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Map<ClickEventType, SRInventory.ClickEventAction> handlers = this.handlers.get(event.getRawSlot());
        if (handlers != null) {
            ClickEventType clickEventType;
            switch (event.getClick()) {
                case LEFT: {
                    clickEventType = ClickEventType.LEFT;
                    break;
                }
                case RIGHT: {
                    clickEventType = ClickEventType.RIGHT;
                    break;
                }
                case SHIFT_LEFT: {
                    clickEventType = ClickEventType.SHIFT_LEFT;
                    break;
                }
                default: {
                    clickEventType = ClickEventType.OTHER;
                }
            }
            SRInventory.ClickEventAction action = handlers.get(clickEventType);
            if (action != null) {
                this.dataCallback.handle(this.wrapper.player(player), action);
            }
        }
    }

    @Generated
    public ActionDataCallback getDataCallback() {
        return this.dataCallback;
    }

    @Generated
    public WrapperBukkit getWrapper() {
        return this.wrapper;
    }

    @Generated
    public Map<Integer, Map<ClickEventType, SRInventory.ClickEventAction>> getHandlers() {
        return this.handlers;
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }

    @Inject
    @Generated
    public BukkitGUIHolder(ActionDataCallback dataCallback, WrapperBukkit wrapper) {
        this.dataCallback = dataCallback;
        this.wrapper = wrapper;
    }

    @Generated
    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }
}

