/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.bukkit.paper.PaperSkinApplier;
import net.skinsrestorer.bukkit.refresher.SkinRefresher;
import net.skinsrestorer.bukkit.spigot.SpigotPassengerUtil;
import net.skinsrestorer.bukkit.utils.MultiPaperUtil;
import net.skinsrestorer.bukkit.utils.SkinApplyBukkitAdapter;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SkinApplierBukkit
implements SkinApplierAccess<Player> {
    private final SkinApplyBukkitAdapter applyAdapter;
    private final SRBukkitAdapter adapter;
    private final Server server;
    private final EventBusImpl eventBus;
    private final SkinRefresher refresh;
    private final SpigotPassengerUtil passengerUtil;
    private final SettingsManager settingsManager;

    @Override
    public void applySkin(Player player, SkinProperty property) {
        if (!player.isOnline()) {
            return;
        }
        this.adapter.runAsync(() -> {
            SkinApplyEventImpl applyEvent = new SkinApplyEventImpl(player, property);
            this.eventBus.callEvent(applyEvent);
            if (applyEvent.isCancelled()) {
                return;
            }
            this.adapter.runSyncToPlayer(player, () -> this.applySkinSync(player, applyEvent.getProperty()));
        });
    }

    public void applySkinSync(Player player, SkinProperty property) {
        if (!player.isOnline()) {
            return;
        }
        if (SpigotPassengerUtil.isAvailable()) {
            this.passengerUtil.ejectPassengers(player);
        }
        if (ReflectionUtil.classExists("com.destroystokyo.paper.profile.PlayerProfile") && PaperSkinApplier.hasProfileMethod()) {
            PaperSkinApplier.applySkin(player, property);
            return;
        }
        this.applyAdapter.applyProperty(player, property);
        if (this.settingsManager.getProperty(AdvancedConfig.TELEPORT_REFRESH).booleanValue()) {
            this.teleportOtherRefresh(player);
        } else {
            this.normalOtherRefresh(player);
        }
        this.refresh.refresh(player);
    }

    private void normalOtherRefresh(Player player) {
        for (Player player2 : this.getSeenByPlayers(player)) {
            this.hideAndShow(player2, player);
        }
    }

    private List<? extends Player> getSeenByPlayers(Player player) {
        return J_U_S_Stream.toList(this.getOnlinePlayers().stream().filter(other -> !other.getUniqueId().equals(player.getUniqueId())).filter(other -> other.canSee(player)));
    }

    private void hideAndShow(Player player, Player other) {
        try {
            player.hidePlayer((Plugin)this.adapter.getPluginInstance(), other);
        }
        catch (NoSuchMethodError ignored) {
            player.hidePlayer(other);
        }
        try {
            player.showPlayer((Plugin)this.adapter.getPluginInstance(), other);
        }
        catch (NoSuchMethodError ignored) {
            player.showPlayer(other);
        }
    }

    private void teleportOtherRefresh(Player player) {
        for (Player player2 : this.getSeenByPlayers(player)) {
            this.refresh.resendInfoPackets(player, player2);
        }
        Location location = player.getLocation();
        player.teleport(new Location(this.server.getWorlds().stream().filter(world -> world != location.getWorld()).findFirst().orElse(location.getWorld()), 0.0, 0.0, 0.0));
        player.teleport(location);
    }

    private Collection<? extends Player> getOnlinePlayers() {
        try {
            return MultiPaperUtil.getOnlinePlayers();
        }
        catch (Throwable e) {
            return this.server.getOnlinePlayers();
        }
    }

    @Inject
    @Generated
    public SkinApplierBukkit(SkinApplyBukkitAdapter applyAdapter, SRBukkitAdapter adapter, Server server, EventBusImpl eventBus, SkinRefresher refresh, SpigotPassengerUtil passengerUtil, SettingsManager settingsManager) {
        this.applyAdapter = applyAdapter;
        this.adapter = adapter;
        this.server = server;
        this.eventBus = eventBus;
        this.refresh = refresh;
        this.passengerUtil = passengerUtil;
        this.settingsManager = settingsManager;
    }
}

