/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.builddata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;

@ApiStatus.Internal
public class BuildData {
    public static final String VERSION;
    public static final String DESCRIPTION;
    public static final String URL;
    public static final String COMMIT;
    public static final String BRANCH;
    public static final String BUILD_TIME;
    public static final String CI_NAME;
    public static final String CI_BUILD_NUMBER;
    public static final String COMMIT_SHORT;
    public static final String[] LOCALES;

    private BuildData() {
    }

    static {
        Properties properties = new Properties();
        try (InputStream inputStream = BuildData.class.getClassLoader().getResourceAsStream("skinsrestorer-build-data.properties");){
            if (inputStream == null) {
                throw new IllegalStateException("Build data properties file not found");
            }
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load build data properties", e);
        }
        VERSION = properties.getProperty("version");
        DESCRIPTION = properties.getProperty("description");
        URL = properties.getProperty("url");
        COMMIT = properties.getProperty("commit");
        BRANCH = properties.getProperty("branch");
        BUILD_TIME = properties.getProperty("build_time");
        CI_NAME = properties.getProperty("ci_name");
        CI_BUILD_NUMBER = properties.getProperty("ci_build_number");
        COMMIT_SHORT = COMMIT.substring(0, 7);
        LOCALES = properties.getProperty("locales").split("\\|");
    }
}

