/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.semver;

import java.util.Arrays;
import lombok.Generated;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;
import net.skinsrestorer.shadow.jbannotations.Nullable;

@ApiStatus.Internal
public class SemanticVersion {
    private final int[] version;

    public SemanticVersion(int[] version) {
        this.version = SemanticVersion.fillZerosIfNeeded(version);
    }

    private static int[] fillZerosIfNeeded(int[] version) {
        int[] newVersion = new int[Math.max(3, version.length)];
        System.arraycopy(version, 0, newVersion, 0, version.length);
        return newVersion;
    }

    public SemanticVersion(int major, int minor, int patch) {
        this(new int[]{major, minor, patch});
    }

    public static SemanticVersion fromString(String version) {
        String[] split = SemanticVersion.stripStringForSemver(version).split("\\.");
        return new SemanticVersion(Arrays.stream(split).mapToInt(Integer::parseInt).toArray());
    }

    private static String stripStringForSemver(String str) {
        StringBuilder result = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (!Character.isDigit(c) && c != '.') break;
            result.append(c);
        }
        return result.toString();
    }

    public boolean isNewerThan(SemanticVersion otherVersion) {
        int i = 0;
        for (int version : this.version) {
            if (i == otherVersion.version.length) {
                return true;
            }
            int otherVersionPart = otherVersion.version[i];
            if (version > otherVersionPart) {
                return true;
            }
            if (version < otherVersionPart) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean isOlderThan(SemanticVersion otherVersion) {
        return !this.isNewerThan(otherVersion) && !this.equals(otherVersion);
    }

    public String toString() {
        return String.join((CharSequence)".", (CharSequence[])Arrays.stream(this.version).mapToObj(String::valueOf).toArray(String[]::new));
    }

    @Generated
    public int[] getVersion() {
        return this.version;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion other = (SemanticVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getVersion(), other.getVersion());
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SemanticVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getVersion());
        return result;
    }
}

