/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.connections;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.skinsrestorer.api.Base64Utils;
import net.skinsrestorer.api.connections.model.MineSkinResponse;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public interface MineSkinAPI {
    public MineSkinResponse genSkin(String var1, @Nullable SkinVariant var2) throws DataRequestException, MineSkinException;

    default public MineSkinResponse genSkin(File file, @Nullable SkinVariant skinVariant) throws DataRequestException, MineSkinException, IOException {
        return this.genSkin(Base64Utils.encodePNGAsUrl(file), skinVariant);
    }

    default public MineSkinResponse genSkin(Path file, @Nullable SkinVariant skinVariant) throws DataRequestException, MineSkinException, IOException {
        return this.genSkin(Base64Utils.encodePNGAsUrl(file), skinVariant);
    }

    default public MineSkinResponse genSkin(BufferedImage image, @Nullable SkinVariant skinVariant) throws DataRequestException, MineSkinException, IOException {
        return this.genSkin(Base64Utils.encodePNGAsUrl(image), skinVariant);
    }

    default public MineSkinResponse genSkin(byte[] pngData, @Nullable SkinVariant skinVariant) throws DataRequestException, MineSkinException {
        return this.genSkin(Base64Utils.encodePNGAsUrl(pngData), skinVariant);
    }
}

