/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import javax.imageio.ImageIO;

public class Base64Utils {
    public static String encode(String data) {
        return Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String decode(String base64) {
        return new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
    }

    public static String encodePNGAsUrl(File pngFile) throws IOException {
        return Base64Utils.encodePNGAsUrl(pngFile.toPath());
    }

    public static String encodePNGAsUrl(Path pngPath) throws IOException {
        return Base64Utils.encodePNGAsUrl(Files.readAllBytes(pngPath));
    }

    public static String encodePNGAsUrl(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        return Base64Utils.encodePNGAsUrl(baos.toByteArray());
    }

    public static String encodePNGAsUrl(byte[] pngData) {
        String base64 = Base64.getEncoder().encodeToString(pngData);
        return Base64Utils.jvmdowngrader$concat$encodePNGAsUrl$1(base64);
    }

    private static /* synthetic */ String jvmdowngrader$concat$encodePNGAsUrl$1(String string) {
        return "data:image/png;base64," + string;
    }
}

